/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MitigationActionParams;
import software.amazon.awssdk.services.iot.model.MitigationActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMitigationActionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeMitigationActionResponse> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::actionName)).setter(DescribeMitigationActionResponse.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::actionTypeAsString)).setter(DescribeMitigationActionResponse.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionArn").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::actionArn)).setter(DescribeMitigationActionResponse.setter(Builder::actionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionArn").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::actionId)).setter(DescribeMitigationActionResponse.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::roleArn)).setter(DescribeMitigationActionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<MitigationActionParams> ACTION_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionParams").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::actionParams)).setter(DescribeMitigationActionResponse.setter(Builder::actionParams)).constructor(MitigationActionParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionParams").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::creationDate)).setter(DescribeMitigationActionResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeMitigationActionResponse.getter(DescribeMitigationActionResponse::lastModifiedDate)).setter(DescribeMitigationActionResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, ACTION_TYPE_FIELD, ACTION_ARN_FIELD, ACTION_ID_FIELD, ROLE_ARN_FIELD, ACTION_PARAMS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String actionName;
    private final String actionType;
    private final String actionArn;
    private final String actionId;
    private final String roleArn;
    private final MitigationActionParams actionParams;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private DescribeMitigationActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.actionType = builder.actionType;
        this.actionArn = builder.actionArn;
        this.actionId = builder.actionId;
        this.roleArn = builder.roleArn;
        this.actionParams = builder.actionParams;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String actionName() {
        return this.actionName;
    }

    public MitigationActionType actionType() {
        return MitigationActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public String actionArn() {
        return this.actionArn;
    }

    public String actionId() {
        return this.actionId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public MitigationActionParams actionParams() {
        return this.actionParams;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMitigationActionResponse)) {
            return false;
        }
        DescribeMitigationActionResponse other = (DescribeMitigationActionResponse)((Object)obj);
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.actionArn(), other.actionArn()) && Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.actionParams(), other.actionParams()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMitigationActionResponse").add("ActionName", (Object)this.actionName()).add("ActionType", (Object)this.actionTypeAsString()).add("ActionArn", (Object)this.actionArn()).add("ActionId", (Object)this.actionId()).add("RoleArn", (Object)this.roleArn()).add("ActionParams", (Object)this.actionParams()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "actionArn": {
                return Optional.ofNullable(clazz.cast(this.actionArn()));
            }
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "actionParams": {
                return Optional.ofNullable(clazz.cast(this.actionParams()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMitigationActionResponse, T> g) {
        return obj -> g.apply((DescribeMitigationActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String actionName;
        private String actionType;
        private String actionArn;
        private String actionId;
        private String roleArn;
        private MitigationActionParams actionParams;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMitigationActionResponse model) {
            super(model);
            this.actionName(model.actionName);
            this.actionType(model.actionType);
            this.actionArn(model.actionArn);
            this.actionId(model.actionId);
            this.roleArn(model.roleArn);
            this.actionParams(model.actionParams);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(MitigationActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getActionArn() {
            return this.actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MitigationActionParams.Builder getActionParams() {
            return this.actionParams != null ? this.actionParams.toBuilder() : null;
        }

        @Override
        public final Builder actionParams(MitigationActionParams actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        public final void setActionParams(MitigationActionParams.BuilderImpl actionParams) {
            this.actionParams = actionParams != null ? actionParams.build() : null;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public DescribeMitigationActionResponse build() {
            return new DescribeMitigationActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMitigationActionResponse> {
        public Builder actionName(String var1);

        public Builder actionType(String var1);

        public Builder actionType(MitigationActionType var1);

        public Builder actionArn(String var1);

        public Builder actionId(String var1);

        public Builder roleArn(String var1);

        public Builder actionParams(MitigationActionParams var1);

        default public Builder actionParams(Consumer<MitigationActionParams.Builder> actionParams) {
            return this.actionParams((MitigationActionParams)((MitigationActionParams.Builder)MitigationActionParams.builder().applyMutation(actionParams)).build());
        }

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

