/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the job execution status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionStatusDetails.Builder, JobExecutionStatusDetails> {
    private static final SdkField<Map<String, String>> DETAILS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("detailsMap")
            .getter(getter(JobExecutionStatusDetails::detailsMap))
            .setter(setter(Builder::detailsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> detailsMap;

    private JobExecutionStatusDetails(BuilderImpl builder) {
        this.detailsMap = builder.detailsMap;
    }

    /**
     * Returns true if the DetailsMap property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDetailsMap() {
        return detailsMap != null && !(detailsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The job execution status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetailsMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The job execution status.
     */
    public Map<String, String> detailsMap() {
        return detailsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetailsMap() ? detailsMap() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionStatusDetails)) {
            return false;
        }
        JobExecutionStatusDetails other = (JobExecutionStatusDetails) obj;
        return hasDetailsMap() == other.hasDetailsMap() && Objects.equals(detailsMap(), other.detailsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobExecutionStatusDetails").add("DetailsMap", hasDetailsMap() ? detailsMap() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detailsMap":
            return Optional.ofNullable(clazz.cast(detailsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionStatusDetails, T> g) {
        return obj -> g.apply((JobExecutionStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionStatusDetails> {
        /**
         * <p>
         * The job execution status.
         * </p>
         * 
         * @param detailsMap
         *        The job execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailsMap(Map<String, String> detailsMap);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> detailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionStatusDetails model) {
            detailsMap(model.detailsMap);
        }

        public final Map<String, String> getDetailsMap() {
            if (detailsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return detailsMap;
        }

        @Override
        public final Builder detailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
            return this;
        }

        public final void setDetailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
        }

        @Override
        public JobExecutionStatusDetails build() {
            return new JobExecutionStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
