/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBillingGroupRequest extends IotRequest implements
        ToCopyableBuilder<CreateBillingGroupRequest.Builder, CreateBillingGroupRequest> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupName").getter(getter(CreateBillingGroupRequest::billingGroupName))
            .setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("billingGroupName").build()).build();

    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField
            .<BillingGroupProperties> builder(MarshallingType.SDK_POJO).memberName("billingGroupProperties")
            .getter(getter(CreateBillingGroupRequest::billingGroupProperties)).setter(setter(Builder::billingGroupProperties))
            .constructor(BillingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateBillingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD,
            BILLING_GROUP_PROPERTIES_FIELD, TAGS_FIELD));

    private final String billingGroupName;

    private final BillingGroupProperties billingGroupProperties;

    private final List<Tag> tags;

    private CreateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name you wish to give to the billing group.
     * </p>
     * 
     * @return The name you wish to give to the billing group.
     */
    public String billingGroupName() {
        return billingGroupName;
    }

    /**
     * <p>
     * The properties of the billing group.
     * </p>
     * 
     * @return The properties of the billing group.
     */
    public BillingGroupProperties billingGroupProperties() {
        return billingGroupProperties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the billing group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata which can be used to manage the billing group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingGroupRequest)) {
            return false;
        }
        CreateBillingGroupRequest other = (CreateBillingGroupRequest) obj;
        return Objects.equals(billingGroupName(), other.billingGroupName())
                && Objects.equals(billingGroupProperties(), other.billingGroupProperties())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBillingGroupRequest").add("BillingGroupName", billingGroupName())
                .add("BillingGroupProperties", billingGroupProperties()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        case "billingGroupProperties":
            return Optional.ofNullable(clazz.cast(billingGroupProperties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingGroupRequest, T> g) {
        return obj -> g.apply((CreateBillingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBillingGroupRequest> {
        /**
         * <p>
         * The name you wish to give to the billing group.
         * </p>
         * 
         * @param billingGroupName
         *        The name you wish to give to the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * 
         * @param billingGroupProperties
         *        The properties of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupProperties(BillingGroupProperties billingGroupProperties);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingGroupProperties.Builder} avoiding the
         * need to create one manually via {@link BillingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #billingGroupProperties(BillingGroupProperties)}.
         * 
         * @param billingGroupProperties
         *        a consumer that will call methods on {@link BillingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroupProperties(BillingGroupProperties)
         */
        default Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return billingGroupProperties(BillingGroupProperties.builder().applyMutation(billingGroupProperties).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the billing group.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the billing group.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the billing group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String billingGroupName;

        private BillingGroupProperties billingGroupProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingGroupRequest model) {
            super(model);
            billingGroupName(model.billingGroupName);
            billingGroupProperties(model.billingGroupProperties);
            tags(model.tags);
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return billingGroupProperties != null ? billingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillingGroupRequest build() {
            return new CreateBillingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
