/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityProfileRequest extends IotRequest implements
        ToCopyableBuilder<UpdateSecurityProfileRequest.Builder, UpdateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(UpdateSecurityProfileRequest::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("securityProfileDescription")
            .getter(getter(UpdateSecurityProfileRequest::securityProfileDescription))
            .setter(setter(Builder::securityProfileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build())
            .build();

    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .memberName("behaviors")
            .getter(getter(UpdateSecurityProfileRequest::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField
            .<Map<String, AlertTarget>> builder(MarshallingType.MAP)
            .memberName("alertTargets")
            .getter(getter(UpdateSecurityProfileRequest::alertTargetsAsStrings))
            .setter(setter(Builder::alertTargetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AlertTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetain")
            .getter(getter(UpdateSecurityProfileRequest::additionalMetricsToRetain))
            .setter(setter(Builder::additionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricToRetain>> ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD = SdkField
            .<List<MetricToRetain>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetainV2")
            .getter(getter(UpdateSecurityProfileRequest::additionalMetricsToRetainV2))
            .setter(setter(Builder::additionalMetricsToRetainV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetainV2")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricToRetain> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricToRetain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_BEHAVIORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteBehaviors").getter(getter(UpdateSecurityProfileRequest::deleteBehaviors))
            .setter(setter(Builder::deleteBehaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteBehaviors").build()).build();

    private static final SdkField<Boolean> DELETE_ALERT_TARGETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAlertTargets").getter(getter(UpdateSecurityProfileRequest::deleteAlertTargets))
            .setter(setter(Builder::deleteAlertTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAlertTargets").build())
            .build();

    private static final SdkField<Boolean> DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAdditionalMetricsToRetain")
            .getter(getter(UpdateSecurityProfileRequest::deleteAdditionalMetricsToRetain))
            .setter(setter(Builder::deleteAdditionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAdditionalMetricsToRetain")
                    .build()).build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("expectedVersion").getter(getter(UpdateSecurityProfileRequest::expectedVersion))
            .setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD,
            ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD, DELETE_BEHAVIORS_FIELD, DELETE_ALERT_TARGETS_FIELD,
            DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD, EXPECTED_VERSION_FIELD));

    private final String securityProfileName;

    private final String securityProfileDescription;

    private final List<Behavior> behaviors;

    private final Map<String, AlertTarget> alertTargets;

    private final List<String> additionalMetricsToRetain;

    private final List<MetricToRetain> additionalMetricsToRetainV2;

    private final Boolean deleteBehaviors;

    private final Boolean deleteAlertTargets;

    private final Boolean deleteAdditionalMetricsToRetain;

    private final Long expectedVersion;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
        this.deleteBehaviors = builder.deleteBehaviors;
        this.deleteAlertTargets = builder.deleteAlertTargets;
        this.deleteAdditionalMetricsToRetain = builder.deleteAdditionalMetricsToRetain;
        this.expectedVersion = builder.expectedVersion;
    }

    /**
     * <p>
     * The name of the security profile you want to update.
     * </p>
     * 
     * @return The name of the security profile you want to update.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * A description of the security profile.
     * </p>
     * 
     * @return A description of the security profile.
     */
    public String securityProfileDescription() {
        return securityProfileDescription;
    }

    /**
     * Returns true if the Behaviors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBehaviors() {
        return behaviors != null && !(behaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBehaviors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public List<Behavior> behaviors() {
        return behaviors;
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlertTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(alertTargets);
    }

    /**
     * Returns true if the AlertTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAlertTargets() {
        return alertTargets != null && !(alertTargets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlertTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return alertTargets;
    }

    /**
     * Returns true if the AdditionalMetricsToRetain property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalMetricsToRetain() {
        return additionalMetricsToRetain != null && !(additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
     * </p>
     * <p>
     * <b>Note:</b> This API field is deprecated. Please use
     * <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalMetricsToRetain()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
     *         <p>
     *         <b>Note:</b> This API field is deprecated. Please use
     *         <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
     */
    public List<String> additionalMetricsToRetain() {
        return additionalMetricsToRetain;
    }

    /**
     * Returns true if the AdditionalMetricsToRetainV2 property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAdditionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2 != null && !(additionalMetricsToRetainV2 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's behaviors, but it is also retained for any metric specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalMetricsToRetainV2()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's behaviors, but it is also retained for any metric specified here.
     */
    public List<MetricToRetain> additionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2;
    }

    /**
     * <p>
     * If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code> are
     * defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>behaviors</code> defined for this security profile. If any
     *         <code>behaviors</code> are defined in the current invocation, an exception occurs.
     */
    public Boolean deleteBehaviors() {
        return deleteBehaviors;
    }

    /**
     * <p>
     * If true, delete all <code>alertTargets</code> defined for this security profile. If any <code>alertTargets</code>
     * are defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>alertTargets</code> defined for this security profile. If any
     *         <code>alertTargets</code> are defined in the current invocation, an exception occurs.
     */
    public Boolean deleteAlertTargets() {
        return deleteAlertTargets;
    }

    /**
     * <p>
     * If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
     * <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
     *         <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
     */
    public Boolean deleteAdditionalMetricsToRetain() {
        return deleteAdditionalMetricsToRetain;
    }

    /**
     * <p>
     * The expected version of the security profile. A new version is generated whenever the security profile is
     * updated. If you specify a value that is different from the actual version, a
     * <code>VersionConflictException</code> is thrown.
     * </p>
     * 
     * @return The expected version of the security profile. A new version is generated whenever the security profile is
     *         updated. If you specify a value that is different from the actual version, a
     *         <code>VersionConflictException</code> is thrown.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetricsToRetainV2());
        hashCode = 31 * hashCode + Objects.hashCode(deleteBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAlertTargets());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAdditionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileDescription(), other.securityProfileDescription())
                && Objects.equals(behaviors(), other.behaviors())
                && Objects.equals(alertTargetsAsStrings(), other.alertTargetsAsStrings())
                && Objects.equals(additionalMetricsToRetain(), other.additionalMetricsToRetain())
                && Objects.equals(additionalMetricsToRetainV2(), other.additionalMetricsToRetainV2())
                && Objects.equals(deleteBehaviors(), other.deleteBehaviors())
                && Objects.equals(deleteAlertTargets(), other.deleteAlertTargets())
                && Objects.equals(deleteAdditionalMetricsToRetain(), other.deleteAdditionalMetricsToRetain())
                && Objects.equals(expectedVersion(), other.expectedVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSecurityProfileRequest").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileDescription", securityProfileDescription()).add("Behaviors", behaviors())
                .add("AlertTargets", alertTargetsAsStrings()).add("AdditionalMetricsToRetain", additionalMetricsToRetain())
                .add("AdditionalMetricsToRetainV2", additionalMetricsToRetainV2()).add("DeleteBehaviors", deleteBehaviors())
                .add("DeleteAlertTargets", deleteAlertTargets())
                .add("DeleteAdditionalMetricsToRetain", deleteAdditionalMetricsToRetain())
                .add("ExpectedVersion", expectedVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileDescription":
            return Optional.ofNullable(clazz.cast(securityProfileDescription()));
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        case "alertTargets":
            return Optional.ofNullable(clazz.cast(alertTargetsAsStrings()));
        case "additionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetain()));
        case "additionalMetricsToRetainV2":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetainV2()));
        case "deleteBehaviors":
            return Optional.ofNullable(clazz.cast(deleteBehaviors()));
        case "deleteAlertTargets":
            return Optional.ofNullable(clazz.cast(deleteAlertTargets()));
        case "deleteAdditionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(deleteAdditionalMetricsToRetain()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileRequest, T> g) {
        return obj -> g.apply((UpdateSecurityProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        /**
         * <p>
         * The name of the security profile you want to update.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * A description of the security profile.
         * </p>
         * 
         * @param securityProfileDescription
         *        A description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileDescription(String securityProfileDescription);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Behavior>.Builder} avoiding the need to
         * create one manually via {@link List<Behavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Behavior>.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on {@link List<Behavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(List<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * </p>
         * <p>
         * <b>Note:</b> This API field is deprecated. Please use
         * <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
         *        <p>
         *        <b>Note:</b> This API field is deprecated. Please use
         *        <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * </p>
         * <p>
         * <b>Note:</b> This API field is deprecated. Please use
         * <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
         *        <p>
         *        <b>Note:</b> This API field is deprecated. Please use
         *        <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetain(String... additionalMetricsToRetain);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricToRetain>.Builder} avoiding the need
         * to create one manually via {@link List<MetricToRetain>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricToRetain>.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalMetricsToRetainV2(List<MetricToRetain>)}.
         * 
         * @param additionalMetricsToRetainV2
         *        a consumer that will call methods on {@link List<MetricToRetain>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalMetricsToRetainV2(List<MetricToRetain>)
         */
        Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2);

        /**
         * <p>
         * If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code>
         * are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteBehaviors
         *        If true, delete all <code>behaviors</code> defined for this security profile. If any
         *        <code>behaviors</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteBehaviors(Boolean deleteBehaviors);

        /**
         * <p>
         * If true, delete all <code>alertTargets</code> defined for this security profile. If any
         * <code>alertTargets</code> are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteAlertTargets
         *        If true, delete all <code>alertTargets</code> defined for this security profile. If any
         *        <code>alertTargets</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAlertTargets(Boolean deleteAlertTargets);

        /**
         * <p>
         * If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
         * <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteAdditionalMetricsToRetain
         *        If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
         *        <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain);

        /**
         * <p>
         * The expected version of the security profile. A new version is generated whenever the security profile is
         * updated. If you specify a value that is different from the actual version, a
         * <code>VersionConflictException</code> is thrown.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the security profile. A new version is generated whenever the security profile
         *        is updated. If you specify a value that is different from the actual version, a
         *        <code>VersionConflictException</code> is thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileDescription;

        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();

        private List<MetricToRetain> additionalMetricsToRetainV2 = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteBehaviors;

        private Boolean deleteAlertTargets;

        private Boolean deleteAdditionalMetricsToRetain;

        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileDescription(model.securityProfileDescription);
            behaviors(model.behaviors);
            alertTargetsWithStrings(model.alertTargets);
            additionalMetricsToRetain(model.additionalMetricsToRetain);
            additionalMetricsToRetainV2(model.additionalMetricsToRetainV2);
            deleteBehaviors(model.deleteBehaviors);
            deleteAlertTargets(model.deleteAlertTargets);
            deleteAdditionalMetricsToRetain(model.deleteAdditionalMetricsToRetain);
            expectedVersion(model.expectedVersion);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return behaviors != null ? behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            return alertTargets != null ? CollectionUtils.mapValues(alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Collection<String> getAdditionalMetricsToRetain() {
            return additionalMetricsToRetain;
        }

        @Override
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetain(String... additionalMetricsToRetain) {
            additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        public final Collection<MetricToRetain.Builder> getAdditionalMetricsToRetainV2() {
            return additionalMetricsToRetainV2 != null ? additionalMetricsToRetainV2.stream().map(MetricToRetain::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copy(additionalMetricsToRetainV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Arrays.asList(additionalMetricsToRetainV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Stream.of(additionalMetricsToRetainV2)
                    .map(c -> MetricToRetain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalMetricsToRetainV2(Collection<MetricToRetain.BuilderImpl> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copyFromBuilder(additionalMetricsToRetainV2);
        }

        public final Boolean getDeleteBehaviors() {
            return deleteBehaviors;
        }

        @Override
        public final Builder deleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
            return this;
        }

        public final void setDeleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
        }

        public final Boolean getDeleteAlertTargets() {
            return deleteAlertTargets;
        }

        @Override
        public final Builder deleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
            return this;
        }

        public final void setDeleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
        }

        public final Boolean getDeleteAdditionalMetricsToRetain() {
            return deleteAdditionalMetricsToRetain;
        }

        @Override
        public final Builder deleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
            return this;
        }

        public final void setDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
