/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventConfigurationsResponse extends IotResponse implements
        ToCopyableBuilder<DescribeEventConfigurationsResponse.Builder, DescribeEventConfigurationsResponse> {
    private static final SdkField<Map<String, Configuration>> EVENT_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, Configuration>> builder(MarshallingType.MAP)
            .memberName("eventConfigurations")
            .getter(getter(DescribeEventConfigurationsResponse::eventConfigurationsAsStrings))
            .setter(setter(Builder::eventConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeEventConfigurationsResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeEventConfigurationsResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONFIGURATIONS_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private final Map<String, Configuration> eventConfigurations;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeEventConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventConfigurations = builder.eventConfigurations;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The event configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event configurations.
     */
    public Map<EventType, Configuration> eventConfigurations() {
        return EventConfigurationsCopier.copyStringToEnum(eventConfigurations);
    }

    /**
     * Returns true if the EventConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventConfigurations() {
        return eventConfigurations != null && !(eventConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The event configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event configurations.
     */
    public Map<String, Configuration> eventConfigurationsAsStrings() {
        return eventConfigurations;
    }

    /**
     * <p>
     * The creation date of the event configuration.
     * </p>
     * 
     * @return The creation date of the event configuration.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the event configurations were last modified.
     * </p>
     * 
     * @return The date the event configurations were last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventConfigurations() ? eventConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventConfigurationsResponse)) {
            return false;
        }
        DescribeEventConfigurationsResponse other = (DescribeEventConfigurationsResponse) obj;
        return hasEventConfigurations() == other.hasEventConfigurations()
                && Objects.equals(eventConfigurationsAsStrings(), other.eventConfigurationsAsStrings())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventConfigurationsResponse")
                .add("EventConfigurations", hasEventConfigurations() ? eventConfigurationsAsStrings() : null)
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventConfigurations":
            return Optional.ofNullable(clazz.cast(eventConfigurationsAsStrings()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeEventConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventConfigurationsResponse> {
        /**
         * <p>
         * The event configurations.
         * </p>
         * 
         * @param eventConfigurations
         *        The event configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations);

        /**
         * <p>
         * The event configurations.
         * </p>
         * 
         * @param eventConfigurations
         *        The event configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations);

        /**
         * <p>
         * The creation date of the event configuration.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the event configurations were last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the event configurations were last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Map<String, Configuration> eventConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventConfigurationsResponse model) {
            super(model);
            eventConfigurationsWithStrings(model.eventConfigurations);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final Map<String, Configuration.Builder> getEventConfigurations() {
            if (eventConfigurations instanceof SdkAutoConstructMap) {
                return null;
            }
            return eventConfigurations != null ? CollectionUtils.mapValues(eventConfigurations, Configuration::toBuilder) : null;
        }

        @Override
        public final Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        public final Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyEnumToString(eventConfigurations);
            return this;
        }

        public final void setEventConfigurations(Map<String, Configuration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public DescribeEventConfigurationsResponse build() {
            return new DescribeEventConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
