/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use Sig V4 authorization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigV4Authorization implements SdkPojo, Serializable,
        ToCopyableBuilder<SigV4Authorization.Builder, SigV4Authorization> {
    private static final SdkField<String> SIGNING_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signingRegion").getter(getter(SigV4Authorization::signingRegion)).setter(setter(Builder::signingRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingRegion").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(SigV4Authorization::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(SigV4Authorization::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_REGION_FIELD,
            SERVICE_NAME_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String signingRegion;

    private final String serviceName;

    private final String roleArn;

    private SigV4Authorization(BuilderImpl builder) {
        this.signingRegion = builder.signingRegion;
        this.serviceName = builder.serviceName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The signing region.
     * </p>
     * 
     * @return The signing region.
     */
    public String signingRegion() {
        return signingRegion;
    }

    /**
     * <p>
     * The service name to use while signing with Sig V4.
     * </p>
     * 
     * @return The service name to use while signing with Sig V4.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The ARN of the signing role.
     * </p>
     * 
     * @return The ARN of the signing role.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingRegion());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigV4Authorization)) {
            return false;
        }
        SigV4Authorization other = (SigV4Authorization) obj;
        return Objects.equals(signingRegion(), other.signingRegion()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SigV4Authorization").add("SigningRegion", signingRegion()).add("ServiceName", serviceName())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingRegion":
            return Optional.ofNullable(clazz.cast(signingRegion()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigV4Authorization, T> g) {
        return obj -> g.apply((SigV4Authorization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigV4Authorization> {
        /**
         * <p>
         * The signing region.
         * </p>
         * 
         * @param signingRegion
         *        The signing region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingRegion(String signingRegion);

        /**
         * <p>
         * The service name to use while signing with Sig V4.
         * </p>
         * 
         * @param serviceName
         *        The service name to use while signing with Sig V4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The ARN of the signing role.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the signing role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String signingRegion;

        private String serviceName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SigV4Authorization model) {
            signingRegion(model.signingRegion);
            serviceName(model.serviceName);
            roleArn(model.roleArn);
        }

        public final String getSigningRegion() {
            return signingRegion;
        }

        @Override
        public final Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public final void setSigningRegion(String signingRegion) {
            this.signingRegion = signingRegion;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public SigV4Authorization build() {
            return new SigV4Authorization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
