/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Device Defender security profile behavior violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViolationEvent implements SdkPojo, Serializable, ToCopyableBuilder<ViolationEvent.Builder, ViolationEvent> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(ViolationEvent::violationId)).setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ViolationEvent::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(ViolationEvent::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
            .memberName("behavior").getter(getter(ViolationEvent::behavior)).setter(setter(Builder::behavior))
            .constructor(Behavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final SdkField<MetricValue> METRIC_VALUE_FIELD = SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
            .memberName("metricValue").getter(getter(ViolationEvent::metricValue)).setter(setter(Builder::metricValue))
            .constructor(MetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()).build();

    private static final SdkField<String> VIOLATION_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationEventType").getter(getter(ViolationEvent::violationEventTypeAsString))
            .setter(setter(Builder::violationEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventType").build())
            .build();

    private static final SdkField<Instant> VIOLATION_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("violationEventTime").getter(getter(ViolationEvent::violationEventTime))
            .setter(setter(Builder::violationEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD,
            THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, METRIC_VALUE_FIELD, VIOLATION_EVENT_TYPE_FIELD,
            VIOLATION_EVENT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationId;

    private final String thingName;

    private final String securityProfileName;

    private final Behavior behavior;

    private final MetricValue metricValue;

    private final String violationEventType;

    private final Instant violationEventTime;

    private ViolationEvent(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.metricValue = builder.metricValue;
        this.violationEventType = builder.violationEventType;
        this.violationEventTime = builder.violationEventTime;
    }

    /**
     * <p>
     * The ID of the violation event.
     * </p>
     * 
     * @return The ID of the violation event.
     */
    public String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The name of the thing responsible for the violation event.
     * </p>
     * 
     * @return The name of the thing responsible for the violation event.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the security profile whose behavior was violated.
     * </p>
     * 
     * @return The name of the security profile whose behavior was violated.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The behavior which was violated.
     * </p>
     * 
     * @return The behavior which was violated.
     */
    public Behavior behavior() {
        return behavior;
    }

    /**
     * <p>
     * The value of the metric (the measurement).
     * </p>
     * 
     * @return The value of the metric (the measurement).
     */
    public MetricValue metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The type of violation event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #violationEventType} will return {@link ViolationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #violationEventTypeAsString}.
     * </p>
     * 
     * @return The type of violation event.
     * @see ViolationEventType
     */
    public ViolationEventType violationEventType() {
        return ViolationEventType.fromValue(violationEventType);
    }

    /**
     * <p>
     * The type of violation event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #violationEventType} will return {@link ViolationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #violationEventTypeAsString}.
     * </p>
     * 
     * @return The type of violation event.
     * @see ViolationEventType
     */
    public String violationEventTypeAsString() {
        return violationEventType;
    }

    /**
     * <p>
     * The time the violation event occurred.
     * </p>
     * 
     * @return The time the violation event occurred.
     */
    public Instant violationEventTime() {
        return violationEventTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behavior());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationEvent)) {
            return false;
        }
        ViolationEvent other = (ViolationEvent) obj;
        return Objects.equals(violationId(), other.violationId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behavior(), other.behavior()) && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(violationEventTypeAsString(), other.violationEventTypeAsString())
                && Objects.equals(violationEventTime(), other.violationEventTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ViolationEvent").add("ViolationId", violationId()).add("ThingName", thingName())
                .add("SecurityProfileName", securityProfileName()).add("Behavior", behavior()).add("MetricValue", metricValue())
                .add("ViolationEventType", violationEventTypeAsString()).add("ViolationEventTime", violationEventTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        case "metricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "violationEventType":
            return Optional.ofNullable(clazz.cast(violationEventTypeAsString()));
        case "violationEventTime":
            return Optional.ofNullable(clazz.cast(violationEventTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViolationEvent, T> g) {
        return obj -> g.apply((ViolationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViolationEvent> {
        /**
         * <p>
         * The ID of the violation event.
         * </p>
         * 
         * @param violationId
         *        The ID of the violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The name of the thing responsible for the violation event.
         * </p>
         * 
         * @param thingName
         *        The name of the thing responsible for the violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the security profile whose behavior was violated.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile whose behavior was violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The behavior which was violated.
         * </p>
         * 
         * @param behavior
         *        The behavior which was violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(Behavior behavior);

        /**
         * <p>
         * The behavior which was violated.
         * </p>
         * This is a convenience that creates an instance of the {@link Behavior.Builder} avoiding the need to create
         * one manually via {@link Behavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link Behavior.Builder#build()} is called immediately and its result is
         * passed to {@link #behavior(Behavior)}.
         * 
         * @param behavior
         *        a consumer that will call methods on {@link Behavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behavior(Behavior)
         */
        default Builder behavior(Consumer<Behavior.Builder> behavior) {
            return behavior(Behavior.builder().applyMutation(behavior).build());
        }

        /**
         * <p>
         * The value of the metric (the measurement).
         * </p>
         * 
         * @param metricValue
         *        The value of the metric (the measurement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(MetricValue metricValue);

        /**
         * <p>
         * The value of the metric (the measurement).
         * </p>
         * This is a convenience that creates an instance of the {@link MetricValue.Builder} avoiding the need to create
         * one manually via {@link MetricValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #metricValue(MetricValue)}.
         * 
         * @param metricValue
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricValue(MetricValue)
         */
        default Builder metricValue(Consumer<MetricValue.Builder> metricValue) {
            return metricValue(MetricValue.builder().applyMutation(metricValue).build());
        }

        /**
         * <p>
         * The type of violation event.
         * </p>
         * 
         * @param violationEventType
         *        The type of violation event.
         * @see ViolationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationEventType
         */
        Builder violationEventType(String violationEventType);

        /**
         * <p>
         * The type of violation event.
         * </p>
         * 
         * @param violationEventType
         *        The type of violation event.
         * @see ViolationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationEventType
         */
        Builder violationEventType(ViolationEventType violationEventType);

        /**
         * <p>
         * The time the violation event occurred.
         * </p>
         * 
         * @param violationEventTime
         *        The time the violation event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventTime(Instant violationEventTime);
    }

    static final class BuilderImpl implements Builder {
        private String violationId;

        private String thingName;

        private String securityProfileName;

        private Behavior behavior;

        private MetricValue metricValue;

        private String violationEventType;

        private Instant violationEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationEvent model) {
            violationId(model.violationId);
            thingName(model.thingName);
            securityProfileName(model.securityProfileName);
            behavior(model.behavior);
            metricValue(model.metricValue);
            violationEventType(model.violationEventType);
            violationEventTime(model.violationEventTime);
        }

        public final String getViolationId() {
            return violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final Behavior.Builder getBehavior() {
            return behavior != null ? behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final MetricValue.Builder getMetricValue() {
            return metricValue != null ? metricValue.toBuilder() : null;
        }

        @Override
        public final Builder metricValue(MetricValue metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(MetricValue.BuilderImpl metricValue) {
            this.metricValue = metricValue != null ? metricValue.build() : null;
        }

        public final String getViolationEventType() {
            return violationEventType;
        }

        @Override
        public final Builder violationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
            return this;
        }

        @Override
        public final Builder violationEventType(ViolationEventType violationEventType) {
            this.violationEventType(violationEventType == null ? null : violationEventType.toString());
            return this;
        }

        public final void setViolationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
        }

        public final Instant getViolationEventTime() {
            return violationEventTime;
        }

        @Override
        public final Builder violationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
            return this;
        }

        public final void setViolationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
        }

        @Override
        public ViolationEvent build() {
            return new ViolationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
