/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerRequest extends IotRequest implements
        ToCopyableBuilder<TestInvokeAuthorizerRequest.Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerName").getter(getter(TestInvokeAuthorizerRequest::authorizerName))
            .setter(setter(Builder::authorizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(TestInvokeAuthorizerRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> TOKEN_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenSignature").getter(getter(TestInvokeAuthorizerRequest::tokenSignature))
            .setter(setter(Builder::tokenSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSignature").build()).build();

    private static final SdkField<HttpContext> HTTP_CONTEXT_FIELD = SdkField.<HttpContext> builder(MarshallingType.SDK_POJO)
            .memberName("httpContext").getter(getter(TestInvokeAuthorizerRequest::httpContext))
            .setter(setter(Builder::httpContext)).constructor(HttpContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpContext").build()).build();

    private static final SdkField<MqttContext> MQTT_CONTEXT_FIELD = SdkField.<MqttContext> builder(MarshallingType.SDK_POJO)
            .memberName("mqttContext").getter(getter(TestInvokeAuthorizerRequest::mqttContext))
            .setter(setter(Builder::mqttContext)).constructor(MqttContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttContext").build()).build();

    private static final SdkField<TlsContext> TLS_CONTEXT_FIELD = SdkField.<TlsContext> builder(MarshallingType.SDK_POJO)
            .memberName("tlsContext").getter(getter(TestInvokeAuthorizerRequest::tlsContext)).setter(setter(Builder::tlsContext))
            .constructor(TlsContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD,
            TOKEN_FIELD, TOKEN_SIGNATURE_FIELD, HTTP_CONTEXT_FIELD, MQTT_CONTEXT_FIELD, TLS_CONTEXT_FIELD));

    private final String authorizerName;

    private final String token;

    private final String tokenSignature;

    private final HttpContext httpContext;

    private final MqttContext mqttContext;

    private final TlsContext tlsContext;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.token = builder.token;
        this.tokenSignature = builder.tokenSignature;
        this.httpContext = builder.httpContext;
        this.mqttContext = builder.mqttContext;
        this.tlsContext = builder.tlsContext;
    }

    /**
     * <p>
     * The custom authorizer name.
     * </p>
     * 
     * @return The custom authorizer name.
     */
    public String authorizerName() {
        return authorizerName;
    }

    /**
     * <p>
     * The token returned by your custom authentication service.
     * </p>
     * 
     * @return The token returned by your custom authentication service.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * The signature made with the token and your custom authentication service's private key. This value must be
     * Base-64-encoded.
     * </p>
     * 
     * @return The signature made with the token and your custom authentication service's private key. This value must
     *         be Base-64-encoded.
     */
    public String tokenSignature() {
        return tokenSignature;
    }

    /**
     * <p>
     * Specifies a test HTTP authorization request.
     * </p>
     * 
     * @return Specifies a test HTTP authorization request.
     */
    public HttpContext httpContext() {
        return httpContext;
    }

    /**
     * <p>
     * Specifies a test MQTT authorization request.
     * </p>
     * 
     * @return Specifies a test MQTT authorization request.
     */
    public MqttContext mqttContext() {
        return mqttContext;
    }

    /**
     * <p>
     * Specifies a test TLS authorization request.
     * </p>
     * 
     * @return Specifies a test TLS authorization request.
     */
    public TlsContext tlsContext() {
        return tlsContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(tokenSignature());
        hashCode = 31 * hashCode + Objects.hashCode(httpContext());
        hashCode = 31 * hashCode + Objects.hashCode(mqttContext());
        hashCode = 31 * hashCode + Objects.hashCode(tlsContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest) obj;
        return Objects.equals(authorizerName(), other.authorizerName()) && Objects.equals(token(), other.token())
                && Objects.equals(tokenSignature(), other.tokenSignature()) && Objects.equals(httpContext(), other.httpContext())
                && Objects.equals(mqttContext(), other.mqttContext()) && Objects.equals(tlsContext(), other.tlsContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerRequest").add("AuthorizerName", authorizerName()).add("Token", token())
                .add("TokenSignature", tokenSignature()).add("HttpContext", httpContext()).add("MqttContext", mqttContext())
                .add("TlsContext", tlsContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerName":
            return Optional.ofNullable(clazz.cast(authorizerName()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "tokenSignature":
            return Optional.ofNullable(clazz.cast(tokenSignature()));
        case "httpContext":
            return Optional.ofNullable(clazz.cast(httpContext()));
        case "mqttContext":
            return Optional.ofNullable(clazz.cast(mqttContext()));
        case "tlsContext":
            return Optional.ofNullable(clazz.cast(tlsContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        /**
         * <p>
         * The custom authorizer name.
         * </p>
         * 
         * @param authorizerName
         *        The custom authorizer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerName(String authorizerName);

        /**
         * <p>
         * The token returned by your custom authentication service.
         * </p>
         * 
         * @param token
         *        The token returned by your custom authentication service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The signature made with the token and your custom authentication service's private key. This value must be
         * Base-64-encoded.
         * </p>
         * 
         * @param tokenSignature
         *        The signature made with the token and your custom authentication service's private key. This value
         *        must be Base-64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenSignature(String tokenSignature);

        /**
         * <p>
         * Specifies a test HTTP authorization request.
         * </p>
         * 
         * @param httpContext
         *        Specifies a test HTTP authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpContext(HttpContext httpContext);

        /**
         * <p>
         * Specifies a test HTTP authorization request.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpContext.Builder} avoiding the need to create
         * one manually via {@link HttpContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpContext.Builder#build()} is called immediately and its result
         * is passed to {@link #httpContext(HttpContext)}.
         * 
         * @param httpContext
         *        a consumer that will call methods on {@link HttpContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpContext(HttpContext)
         */
        default Builder httpContext(Consumer<HttpContext.Builder> httpContext) {
            return httpContext(HttpContext.builder().applyMutation(httpContext).build());
        }

        /**
         * <p>
         * Specifies a test MQTT authorization request.
         * </p>
         * 
         * @param mqttContext
         *        Specifies a test MQTT authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqttContext(MqttContext mqttContext);

        /**
         * <p>
         * Specifies a test MQTT authorization request.
         * </p>
         * This is a convenience that creates an instance of the {@link MqttContext.Builder} avoiding the need to create
         * one manually via {@link MqttContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link MqttContext.Builder#build()} is called immediately and its result
         * is passed to {@link #mqttContext(MqttContext)}.
         * 
         * @param mqttContext
         *        a consumer that will call methods on {@link MqttContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mqttContext(MqttContext)
         */
        default Builder mqttContext(Consumer<MqttContext.Builder> mqttContext) {
            return mqttContext(MqttContext.builder().applyMutation(mqttContext).build());
        }

        /**
         * <p>
         * Specifies a test TLS authorization request.
         * </p>
         * 
         * @param tlsContext
         *        Specifies a test TLS authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsContext(TlsContext tlsContext);

        /**
         * <p>
         * Specifies a test TLS authorization request.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsContext.Builder} avoiding the need to create
         * one manually via {@link TlsContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsContext.Builder#build()} is called immediately and its result
         * is passed to {@link #tlsContext(TlsContext)}.
         * 
         * @param tlsContext
         *        a consumer that will call methods on {@link TlsContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsContext(TlsContext)
         */
        default Builder tlsContext(Consumer<TlsContext.Builder> tlsContext) {
            return tlsContext(TlsContext.builder().applyMutation(tlsContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String authorizerName;

        private String token;

        private String tokenSignature;

        private HttpContext httpContext;

        private MqttContext mqttContext;

        private TlsContext tlsContext;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            authorizerName(model.authorizerName);
            token(model.token);
            tokenSignature(model.tokenSignature);
            httpContext(model.httpContext);
            mqttContext(model.mqttContext);
            tlsContext(model.tlsContext);
        }

        public final String getAuthorizerName() {
            return authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getTokenSignature() {
            return tokenSignature;
        }

        @Override
        public final Builder tokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
            return this;
        }

        public final void setTokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
        }

        public final HttpContext.Builder getHttpContext() {
            return httpContext != null ? httpContext.toBuilder() : null;
        }

        @Override
        public final Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public final void setHttpContext(HttpContext.BuilderImpl httpContext) {
            this.httpContext = httpContext != null ? httpContext.build() : null;
        }

        public final MqttContext.Builder getMqttContext() {
            return mqttContext != null ? mqttContext.toBuilder() : null;
        }

        @Override
        public final Builder mqttContext(MqttContext mqttContext) {
            this.mqttContext = mqttContext;
            return this;
        }

        public final void setMqttContext(MqttContext.BuilderImpl mqttContext) {
            this.mqttContext = mqttContext != null ? mqttContext.build() : null;
        }

        public final TlsContext.Builder getTlsContext() {
            return tlsContext != null ? tlsContext.toBuilder() : null;
        }

        @Override
        public final Builder tlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        public final void setTlsContext(TlsContext.BuilderImpl tlsContext) {
            this.tlsContext = tlsContext != null ? tlsContext.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
