/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for pre-signed URLs. Valid when <code>protocols</code> contains HTTP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsJobPresignedUrlConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsJobPresignedUrlConfig.Builder, AwsJobPresignedUrlConfig> {
    private static final SdkField<Long> EXPIRES_IN_SEC_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("expiresInSec").getter(getter(AwsJobPresignedUrlConfig::expiresInSec))
            .setter(setter(Builder::expiresInSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresInSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRES_IN_SEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long expiresInSec;

    private AwsJobPresignedUrlConfig(BuilderImpl builder) {
        this.expiresInSec = builder.expiresInSec;
    }

    /**
     * <p>
     * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800 seconds.
     * Pre-signed URLs are generated when a request for the job document is received.
     * </p>
     * 
     * @return How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
     *         seconds. Pre-signed URLs are generated when a request for the job document is received.
     */
    public Long expiresInSec() {
        return expiresInSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSec());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobPresignedUrlConfig)) {
            return false;
        }
        AwsJobPresignedUrlConfig other = (AwsJobPresignedUrlConfig) obj;
        return Objects.equals(expiresInSec(), other.expiresInSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsJobPresignedUrlConfig").add("ExpiresInSec", expiresInSec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expiresInSec":
            return Optional.ofNullable(clazz.cast(expiresInSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsJobPresignedUrlConfig, T> g) {
        return obj -> g.apply((AwsJobPresignedUrlConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsJobPresignedUrlConfig> {
        /**
         * <p>
         * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
         * seconds. Pre-signed URLs are generated when a request for the job document is received.
         * </p>
         * 
         * @param expiresInSec
         *        How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
         *        seconds. Pre-signed URLs are generated when a request for the job document is received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSec(Long expiresInSec);
    }

    static final class BuilderImpl implements Builder {
        private Long expiresInSec;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobPresignedUrlConfig model) {
            expiresInSec(model.expiresInSec);
        }

        public final Long getExpiresInSec() {
            return expiresInSec;
        }

        @Override
        public final Builder expiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
            return this;
        }

        public final void setExpiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
        }

        @Override
        public AwsJobPresignedUrlConfig build() {
            return new AwsJobPresignedUrlConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
