/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProvisioningTemplateVersionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, DeleteProvisioningTemplateVersionRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(DeleteProvisioningTemplateVersionRequest.getter(DeleteProvisioningTemplateVersionRequest::templateName)).setter(DeleteProvisioningTemplateVersionRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateName").build()}).build();
    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("versionId").getter(DeleteProvisioningTemplateVersionRequest.getter(DeleteProvisioningTemplateVersionRequest::versionId)).setter(DeleteProvisioningTemplateVersionRequest.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, VERSION_ID_FIELD));
    private final String templateName;
    private final Integer versionId;

    private DeleteProvisioningTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.versionId = builder.versionId;
    }

    public String templateName() {
        return this.templateName;
    }

    public Integer versionId() {
        return this.versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProvisioningTemplateVersionRequest)) {
            return false;
        }
        DeleteProvisioningTemplateVersionRequest other = (DeleteProvisioningTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteProvisioningTemplateVersionRequest").add("TemplateName", (Object)this.templateName()).add("VersionId", (Object)this.versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProvisioningTemplateVersionRequest, T> g) {
        return obj -> g.apply((DeleteProvisioningTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private Integer versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProvisioningTemplateVersionRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.versionId(model.versionId);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final Integer getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProvisioningTemplateVersionRequest build() {
            return new DeleteProvisioningTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProvisioningTemplateVersionRequest> {
        public Builder templateName(String var1);

        public Builder versionId(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

