/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CannedAccessControlList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Action> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(S3Action.getter(S3Action::roleArn)).setter(S3Action.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3Action.getter(S3Action::bucketName)).setter(S3Action.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(S3Action.getter(S3Action::key)).setter(S3Action.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> CANNED_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cannedAcl").getter(S3Action.getter(S3Action::cannedAclAsString)).setter(S3Action.setter(Builder::cannedAcl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cannedAcl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BUCKET_NAME_FIELD, KEY_FIELD, CANNED_ACL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String bucketName;
    private final String key;
    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String key() {
        return this.key;
    }

    public CannedAccessControlList cannedAcl() {
        return CannedAccessControlList.fromValue(this.cannedAcl);
    }

    public String cannedAclAsString() {
        return this.cannedAcl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAclAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.cannedAclAsString(), other.cannedAclAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3Action").add("RoleArn", (Object)this.roleArn()).add("BucketName", (Object)this.bucketName()).add("Key", (Object)this.key()).add("CannedAcl", (Object)this.cannedAclAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "cannedAcl": {
                return Optional.ofNullable(clazz.cast(this.cannedAclAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Action, T> g) {
        return obj -> g.apply((S3Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String bucketName;
        private String key;
        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.roleArn(model.roleArn);
            this.bucketName(model.bucketName);
            this.key(model.key);
            this.cannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getCannedAcl() {
            return this.cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl == null ? null : cannedAcl.toString());
            return this;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        public S3Action build() {
            return new S3Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Action> {
        public Builder roleArn(String var1);

        public Builder bucketName(String var1);

        public Builder key(String var1);

        public Builder cannedAcl(String var1);

        public Builder cannedAcl(CannedAccessControlList var1);
    }
}

