/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary counts of how many tasks for findings are in a particular state. This information is included in the
 * response from DescribeAuditMitigationActionsTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskStatisticsForAuditCheck implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskStatisticsForAuditCheck.Builder, TaskStatisticsForAuditCheck> {
    private static final SdkField<Long> TOTAL_FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalFindingsCount").getter(getter(TaskStatisticsForAuditCheck::totalFindingsCount))
            .setter(setter(Builder::totalFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindingsCount").build())
            .build();

    private static final SdkField<Long> FAILED_FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("failedFindingsCount").getter(getter(TaskStatisticsForAuditCheck::failedFindingsCount))
            .setter(setter(Builder::failedFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedFindingsCount").build())
            .build();

    private static final SdkField<Long> SUCCEEDED_FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("succeededFindingsCount").getter(getter(TaskStatisticsForAuditCheck::succeededFindingsCount))
            .setter(setter(Builder::succeededFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededFindingsCount").build())
            .build();

    private static final SdkField<Long> SKIPPED_FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("skippedFindingsCount").getter(getter(TaskStatisticsForAuditCheck::skippedFindingsCount))
            .setter(setter(Builder::skippedFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedFindingsCount").build())
            .build();

    private static final SdkField<Long> CANCELED_FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("canceledFindingsCount").getter(getter(TaskStatisticsForAuditCheck::canceledFindingsCount))
            .setter(setter(Builder::canceledFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canceledFindingsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FINDINGS_COUNT_FIELD,
            FAILED_FINDINGS_COUNT_FIELD, SUCCEEDED_FINDINGS_COUNT_FIELD, SKIPPED_FINDINGS_COUNT_FIELD,
            CANCELED_FINDINGS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalFindingsCount;

    private final Long failedFindingsCount;

    private final Long succeededFindingsCount;

    private final Long skippedFindingsCount;

    private final Long canceledFindingsCount;

    private TaskStatisticsForAuditCheck(BuilderImpl builder) {
        this.totalFindingsCount = builder.totalFindingsCount;
        this.failedFindingsCount = builder.failedFindingsCount;
        this.succeededFindingsCount = builder.succeededFindingsCount;
        this.skippedFindingsCount = builder.skippedFindingsCount;
        this.canceledFindingsCount = builder.canceledFindingsCount;
    }

    /**
     * <p>
     * The total number of findings to which a task is being applied.
     * </p>
     * 
     * @return The total number of findings to which a task is being applied.
     */
    public Long totalFindingsCount() {
        return totalFindingsCount;
    }

    /**
     * <p>
     * The number of findings for which at least one of the actions failed when applied.
     * </p>
     * 
     * @return The number of findings for which at least one of the actions failed when applied.
     */
    public Long failedFindingsCount() {
        return failedFindingsCount;
    }

    /**
     * <p>
     * The number of findings for which all mitigation actions succeeded when applied.
     * </p>
     * 
     * @return The number of findings for which all mitigation actions succeeded when applied.
     */
    public Long succeededFindingsCount() {
        return succeededFindingsCount;
    }

    /**
     * <p>
     * The number of findings skipped because of filter conditions provided in the parameters to the command.
     * </p>
     * 
     * @return The number of findings skipped because of filter conditions provided in the parameters to the command.
     */
    public Long skippedFindingsCount() {
        return skippedFindingsCount;
    }

    /**
     * <p>
     * The number of findings to which the mitigation action task was canceled when applied.
     * </p>
     * 
     * @return The number of findings to which the mitigation action task was canceled when applied.
     */
    public Long canceledFindingsCount() {
        return canceledFindingsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(succeededFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(skippedFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(canceledFindingsCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskStatisticsForAuditCheck)) {
            return false;
        }
        TaskStatisticsForAuditCheck other = (TaskStatisticsForAuditCheck) obj;
        return Objects.equals(totalFindingsCount(), other.totalFindingsCount())
                && Objects.equals(failedFindingsCount(), other.failedFindingsCount())
                && Objects.equals(succeededFindingsCount(), other.succeededFindingsCount())
                && Objects.equals(skippedFindingsCount(), other.skippedFindingsCount())
                && Objects.equals(canceledFindingsCount(), other.canceledFindingsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TaskStatisticsForAuditCheck").add("TotalFindingsCount", totalFindingsCount())
                .add("FailedFindingsCount", failedFindingsCount()).add("SucceededFindingsCount", succeededFindingsCount())
                .add("SkippedFindingsCount", skippedFindingsCount()).add("CanceledFindingsCount", canceledFindingsCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalFindingsCount":
            return Optional.ofNullable(clazz.cast(totalFindingsCount()));
        case "failedFindingsCount":
            return Optional.ofNullable(clazz.cast(failedFindingsCount()));
        case "succeededFindingsCount":
            return Optional.ofNullable(clazz.cast(succeededFindingsCount()));
        case "skippedFindingsCount":
            return Optional.ofNullable(clazz.cast(skippedFindingsCount()));
        case "canceledFindingsCount":
            return Optional.ofNullable(clazz.cast(canceledFindingsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskStatisticsForAuditCheck, T> g) {
        return obj -> g.apply((TaskStatisticsForAuditCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskStatisticsForAuditCheck> {
        /**
         * <p>
         * The total number of findings to which a task is being applied.
         * </p>
         * 
         * @param totalFindingsCount
         *        The total number of findings to which a task is being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindingsCount(Long totalFindingsCount);

        /**
         * <p>
         * The number of findings for which at least one of the actions failed when applied.
         * </p>
         * 
         * @param failedFindingsCount
         *        The number of findings for which at least one of the actions failed when applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFindingsCount(Long failedFindingsCount);

        /**
         * <p>
         * The number of findings for which all mitigation actions succeeded when applied.
         * </p>
         * 
         * @param succeededFindingsCount
         *        The number of findings for which all mitigation actions succeeded when applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededFindingsCount(Long succeededFindingsCount);

        /**
         * <p>
         * The number of findings skipped because of filter conditions provided in the parameters to the command.
         * </p>
         * 
         * @param skippedFindingsCount
         *        The number of findings skipped because of filter conditions provided in the parameters to the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedFindingsCount(Long skippedFindingsCount);

        /**
         * <p>
         * The number of findings to which the mitigation action task was canceled when applied.
         * </p>
         * 
         * @param canceledFindingsCount
         *        The number of findings to which the mitigation action task was canceled when applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canceledFindingsCount(Long canceledFindingsCount);
    }

    static final class BuilderImpl implements Builder {
        private Long totalFindingsCount;

        private Long failedFindingsCount;

        private Long succeededFindingsCount;

        private Long skippedFindingsCount;

        private Long canceledFindingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskStatisticsForAuditCheck model) {
            totalFindingsCount(model.totalFindingsCount);
            failedFindingsCount(model.failedFindingsCount);
            succeededFindingsCount(model.succeededFindingsCount);
            skippedFindingsCount(model.skippedFindingsCount);
            canceledFindingsCount(model.canceledFindingsCount);
        }

        public final Long getTotalFindingsCount() {
            return totalFindingsCount;
        }

        @Override
        public final Builder totalFindingsCount(Long totalFindingsCount) {
            this.totalFindingsCount = totalFindingsCount;
            return this;
        }

        public final void setTotalFindingsCount(Long totalFindingsCount) {
            this.totalFindingsCount = totalFindingsCount;
        }

        public final Long getFailedFindingsCount() {
            return failedFindingsCount;
        }

        @Override
        public final Builder failedFindingsCount(Long failedFindingsCount) {
            this.failedFindingsCount = failedFindingsCount;
            return this;
        }

        public final void setFailedFindingsCount(Long failedFindingsCount) {
            this.failedFindingsCount = failedFindingsCount;
        }

        public final Long getSucceededFindingsCount() {
            return succeededFindingsCount;
        }

        @Override
        public final Builder succeededFindingsCount(Long succeededFindingsCount) {
            this.succeededFindingsCount = succeededFindingsCount;
            return this;
        }

        public final void setSucceededFindingsCount(Long succeededFindingsCount) {
            this.succeededFindingsCount = succeededFindingsCount;
        }

        public final Long getSkippedFindingsCount() {
            return skippedFindingsCount;
        }

        @Override
        public final Builder skippedFindingsCount(Long skippedFindingsCount) {
            this.skippedFindingsCount = skippedFindingsCount;
            return this;
        }

        public final void setSkippedFindingsCount(Long skippedFindingsCount) {
            this.skippedFindingsCount = skippedFindingsCount;
        }

        public final Long getCanceledFindingsCount() {
            return canceledFindingsCount;
        }

        @Override
        public final Builder canceledFindingsCount(Long canceledFindingsCount) {
            this.canceledFindingsCount = canceledFindingsCount;
            return this;
        }

        public final void setCanceledFindingsCount(Long canceledFindingsCount) {
            this.canceledFindingsCount = canceledFindingsCount;
        }

        @Override
        public TaskStatisticsForAuditCheck build() {
            return new TaskStatisticsForAuditCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
