/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMitigationActionsResponse extends IotResponse implements
        ToCopyableBuilder<ListMitigationActionsResponse.Builder, ListMitigationActionsResponse> {
    private static final SdkField<List<MitigationActionIdentifier>> ACTION_IDENTIFIERS_FIELD = SdkField
            .<List<MitigationActionIdentifier>> builder(MarshallingType.LIST)
            .memberName("actionIdentifiers")
            .getter(getter(ListMitigationActionsResponse::actionIdentifiers))
            .setter(setter(Builder::actionIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MitigationActionIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(MitigationActionIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMitigationActionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MitigationActionIdentifier> actionIdentifiers;

    private final String nextToken;

    private ListMitigationActionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionIdentifiers = builder.actionIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ActionIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasActionIdentifiers() {
        return actionIdentifiers != null && !(actionIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of actions that matched the specified filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of actions that matched the specified filter criteria.
     */
    public List<MitigationActionIdentifier> actionIdentifiers() {
        return actionIdentifiers;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionIdentifiers() ? actionIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMitigationActionsResponse)) {
            return false;
        }
        ListMitigationActionsResponse other = (ListMitigationActionsResponse) obj;
        return hasActionIdentifiers() == other.hasActionIdentifiers()
                && Objects.equals(actionIdentifiers(), other.actionIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMitigationActionsResponse")
                .add("ActionIdentifiers", hasActionIdentifiers() ? actionIdentifiers() : null).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionIdentifiers":
            return Optional.ofNullable(clazz.cast(actionIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMitigationActionsResponse, T> g) {
        return obj -> g.apply((ListMitigationActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMitigationActionsResponse> {
        /**
         * <p>
         * A set of actions that matched the specified filter criteria.
         * </p>
         * 
         * @param actionIdentifiers
         *        A set of actions that matched the specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionIdentifiers(Collection<MitigationActionIdentifier> actionIdentifiers);

        /**
         * <p>
         * A set of actions that matched the specified filter criteria.
         * </p>
         * 
         * @param actionIdentifiers
         *        A set of actions that matched the specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionIdentifiers(MitigationActionIdentifier... actionIdentifiers);

        /**
         * <p>
         * A set of actions that matched the specified filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MitigationActionIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<MitigationActionIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MitigationActionIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link #actionIdentifiers(List<MitigationActionIdentifier>)}.
         * 
         * @param actionIdentifiers
         *        a consumer that will call methods on {@link List<MitigationActionIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionIdentifiers(List<MitigationActionIdentifier>)
         */
        Builder actionIdentifiers(Consumer<MitigationActionIdentifier.Builder>... actionIdentifiers);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<MitigationActionIdentifier> actionIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMitigationActionsResponse model) {
            super(model);
            actionIdentifiers(model.actionIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<MitigationActionIdentifier.Builder> getActionIdentifiers() {
            if (actionIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return actionIdentifiers != null ? actionIdentifiers.stream().map(MitigationActionIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionIdentifiers(Collection<MitigationActionIdentifier> actionIdentifiers) {
            this.actionIdentifiers = MitigationActionIdentifierListCopier.copy(actionIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIdentifiers(MitigationActionIdentifier... actionIdentifiers) {
            actionIdentifiers(Arrays.asList(actionIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIdentifiers(Consumer<MitigationActionIdentifier.Builder>... actionIdentifiers) {
            actionIdentifiers(Stream.of(actionIdentifiers)
                    .map(c -> MitigationActionIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionIdentifiers(Collection<MitigationActionIdentifier.BuilderImpl> actionIdentifiers) {
            this.actionIdentifiers = MitigationActionIdentifierListCopier.copyFromBuilder(actionIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMitigationActionsResponse build() {
            return new ListMitigationActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
