/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddThingToThingGroupRequest extends IotRequest implements
        ToCopyableBuilder<AddThingToThingGroupRequest.Builder, AddThingToThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupName").getter(getter(AddThingToThingGroupRequest::thingGroupName))
            .setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()).build();

    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupArn").getter(getter(AddThingToThingGroupRequest::thingGroupArn))
            .setter(setter(Builder::thingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(AddThingToThingGroupRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(AddThingToThingGroupRequest::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overrideDynamicGroups").getter(getter(AddThingToThingGroupRequest::overrideDynamicGroups))
            .setter(setter(Builder::overrideDynamicGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD, OVERRIDE_DYNAMIC_GROUPS_FIELD));

    private final String thingGroupName;

    private final String thingGroupArn;

    private final String thingName;

    private final String thingArn;

    private final Boolean overrideDynamicGroups;

    private AddThingToThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupArn = builder.thingGroupArn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    /**
     * <p>
     * The name of the group to which you are adding a thing.
     * </p>
     * 
     * @return The name of the group to which you are adding a thing.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The ARN of the group to which you are adding a thing.
     * </p>
     * 
     * @return The ARN of the group to which you are adding a thing.
     */
    public String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The name of the thing to add to a group.
     * </p>
     * 
     * @return The name of the thing to add to a group.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the thing to add to a group.
     * </p>
     * 
     * @return The ARN of the thing to add to a group.
     */
    public String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10
     * thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes
     * the thing from the last dynamic group.
     * </p>
     * 
     * @return Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs
     *         to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static
     *         group removes the thing from the last dynamic group.
     */
    public Boolean overrideDynamicGroups() {
        return overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(overrideDynamicGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddThingToThingGroupRequest)) {
            return false;
        }
        AddThingToThingGroupRequest other = (AddThingToThingGroupRequest) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupArn(), other.thingGroupArn())
                && Objects.equals(thingName(), other.thingName()) && Objects.equals(thingArn(), other.thingArn())
                && Objects.equals(overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddThingToThingGroupRequest").add("ThingGroupName", thingGroupName())
                .add("ThingGroupArn", thingGroupArn()).add("ThingName", thingName()).add("ThingArn", thingArn())
                .add("OverrideDynamicGroups", overrideDynamicGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "overrideDynamicGroups":
            return Optional.ofNullable(clazz.cast(overrideDynamicGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddThingToThingGroupRequest, T> g) {
        return obj -> g.apply((AddThingToThingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddThingToThingGroupRequest> {
        /**
         * <p>
         * The name of the group to which you are adding a thing.
         * </p>
         * 
         * @param thingGroupName
         *        The name of the group to which you are adding a thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The ARN of the group to which you are adding a thing.
         * </p>
         * 
         * @param thingGroupArn
         *        The ARN of the group to which you are adding a thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The name of the thing to add to a group.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to add to a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the thing to add to a group.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing to add to a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to
         * 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group
         * removes the thing from the last dynamic group.
         * </p>
         * 
         * @param overrideDynamicGroups
         *        Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing
         *        belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing
         *        to a static group removes the thing from the last dynamic group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideDynamicGroups(Boolean overrideDynamicGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupArn;

        private String thingName;

        private String thingArn;

        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(AddThingToThingGroupRequest model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupArn(model.thingGroupArn);
            thingName(model.thingName);
            thingArn(model.thingArn);
            overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final Boolean getOverrideDynamicGroups() {
            return overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddThingToThingGroupRequest build() {
            return new AddThingToThingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
