/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuthorizersResponse extends IotResponse implements
        ToCopyableBuilder<ListAuthorizersResponse.Builder, ListAuthorizersResponse> {
    private static final SdkField<List<AuthorizerSummary>> AUTHORIZERS_FIELD = SdkField
            .<List<AuthorizerSummary>> builder(MarshallingType.LIST)
            .memberName("authorizers")
            .getter(getter(ListAuthorizersResponse::authorizers))
            .setter(setter(Builder::authorizers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMarker").getter(getter(ListAuthorizersResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZERS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<AuthorizerSummary> authorizers;

    private final String nextMarker;

    private ListAuthorizersResponse(BuilderImpl builder) {
        super(builder);
        this.authorizers = builder.authorizers;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the Authorizers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAuthorizers() {
        return authorizers != null && !(authorizers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorizers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthorizers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authorizers.
     */
    public List<AuthorizerSummary> authorizers() {
        return authorizers;
    }

    /**
     * <p>
     * A marker used to get the next set of results.
     * </p>
     * 
     * @return A marker used to get the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizers() ? authorizers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthorizersResponse)) {
            return false;
        }
        ListAuthorizersResponse other = (ListAuthorizersResponse) obj;
        return hasAuthorizers() == other.hasAuthorizers() && Objects.equals(authorizers(), other.authorizers())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuthorizersResponse").add("Authorizers", hasAuthorizers() ? authorizers() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizers":
            return Optional.ofNullable(clazz.cast(authorizers()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuthorizersResponse, T> g) {
        return obj -> g.apply((ListAuthorizersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAuthorizersResponse> {
        /**
         * <p>
         * The authorizers.
         * </p>
         * 
         * @param authorizers
         *        The authorizers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizers(Collection<AuthorizerSummary> authorizers);

        /**
         * <p>
         * The authorizers.
         * </p>
         * 
         * @param authorizers
         *        The authorizers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizers(AuthorizerSummary... authorizers);

        /**
         * <p>
         * The authorizers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthorizerSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AuthorizerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthorizerSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizers(List<AuthorizerSummary>)}.
         * 
         * @param authorizers
         *        a consumer that will call methods on {@link List<AuthorizerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizers(List<AuthorizerSummary>)
         */
        Builder authorizers(Consumer<AuthorizerSummary.Builder>... authorizers);

        /**
         * <p>
         * A marker used to get the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        A marker used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuthorizerSummary> authorizers = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuthorizersResponse model) {
            super(model);
            authorizers(model.authorizers);
            nextMarker(model.nextMarker);
        }

        public final Collection<AuthorizerSummary.Builder> getAuthorizers() {
            if (authorizers instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizers != null ? authorizers.stream().map(AuthorizerSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder authorizers(Collection<AuthorizerSummary> authorizers) {
            this.authorizers = AuthorizersCopier.copy(authorizers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(AuthorizerSummary... authorizers) {
            authorizers(Arrays.asList(authorizers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(Consumer<AuthorizerSummary.Builder>... authorizers) {
            authorizers(Stream.of(authorizers).map(c -> AuthorizerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAuthorizers(Collection<AuthorizerSummary.BuilderImpl> authorizers) {
            this.authorizers = AuthorizersCopier.copyFromBuilder(authorizers);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListAuthorizersResponse build() {
            return new ListAuthorizersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
