/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the ListCertificatesByCA operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificatesByCaRequest extends IotRequest implements
        ToCopyableBuilder<ListCertificatesByCaRequest.Builder, ListCertificatesByCaRequest> {
    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caCertificateId").getter(getter(ListCertificatesByCaRequest::caCertificateId))
            .setter(setter(Builder::caCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caCertificateId").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pageSize").getter(getter(ListCertificatesByCaRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageSize").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(ListCertificatesByCaRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<Boolean> ASCENDING_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ascendingOrder").getter(getter(ListCertificatesByCaRequest::ascendingOrder))
            .setter(setter(Builder::ascendingOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isAscendingOrder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CA_CERTIFICATE_ID_FIELD,
            PAGE_SIZE_FIELD, MARKER_FIELD, ASCENDING_ORDER_FIELD));

    private final String caCertificateId;

    private final Integer pageSize;

    private final String marker;

    private final Boolean ascendingOrder;

    private ListCertificatesByCaRequest(BuilderImpl builder) {
        super(builder);
        this.caCertificateId = builder.caCertificateId;
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    /**
     * <p>
     * The ID of the CA certificate. This operation will list all registered device certificate that were signed by this
     * CA certificate.
     * </p>
     * 
     * @return The ID of the CA certificate. This operation will list all registered device certificate that were signed
     *         by this CA certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The result page size.
     * </p>
     * 
     * @return The result page size.
     */
    public Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies the order for results. If True, the results are returned in ascending order, based on the creation
     * date.
     * </p>
     * 
     * @return Specifies the order for results. If True, the results are returned in ascending order, based on the
     *         creation date.
     */
    public Boolean ascendingOrder() {
        return ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(ascendingOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCaRequest)) {
            return false;
        }
        ListCertificatesByCaRequest other = (ListCertificatesByCaRequest) obj;
        return Objects.equals(caCertificateId(), other.caCertificateId()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(marker(), other.marker()) && Objects.equals(ascendingOrder(), other.ascendingOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCertificatesByCaRequest").add("CaCertificateId", caCertificateId())
                .add("PageSize", pageSize()).add("Marker", marker()).add("AscendingOrder", ascendingOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "pageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ascendingOrder":
            return Optional.ofNullable(clazz.cast(ascendingOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesByCaRequest, T> g) {
        return obj -> g.apply((ListCertificatesByCaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCertificatesByCaRequest> {
        /**
         * <p>
         * The ID of the CA certificate. This operation will list all registered device certificate that were signed by
         * this CA certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The ID of the CA certificate. This operation will list all registered device certificate that were
         *        signed by this CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The result page size.
         * </p>
         * 
         * @param pageSize
         *        The result page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies the order for results. If True, the results are returned in ascending order, based on the creation
         * date.
         * </p>
         * 
         * @param ascendingOrder
         *        Specifies the order for results. If True, the results are returned in ascending order, based on the
         *        creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String caCertificateId;

        private Integer pageSize;

        private String marker;

        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCaRequest model) {
            super(model);
            caCertificateId(model.caCertificateId);
            pageSize(model.pageSize);
            marker(model.marker);
            ascendingOrder(model.ascendingOrder);
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCertificatesByCaRequest build() {
            return new ListCertificatesByCaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
