/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalMetricsToRetainListCopier;
import software.amazon.awssdk.services.iot.model.AdditionalMetricsToRetainV2ListCopier;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.MetricToRetain;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecurityProfileRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::securityProfileName)).setter(CreateSecurityProfileRequest.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileDescription").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::securityProfileDescription)).setter(CreateSecurityProfileRequest.setter(Builder::securityProfileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build()}).build();
    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("behaviors").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::behaviors)).setter(CreateSecurityProfileRequest.setter(Builder::behaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("alertTargets").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::alertTargetsAsStrings)).setter(CreateSecurityProfileRequest.setter(Builder::alertTargetsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlertTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalMetricsToRetain").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::additionalMetricsToRetain)).setter(CreateSecurityProfileRequest.setter(Builder::additionalMetricsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricToRetain>> ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalMetricsToRetainV2").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::additionalMetricsToRetainV2)).setter(CreateSecurityProfileRequest.setter(Builder::additionalMetricsToRetainV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetainV2").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricToRetain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::tags)).setter(CreateSecurityProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD, ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD, TAGS_FIELD));
    private final String securityProfileName;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;
    private final List<String> additionalMetricsToRetain;
    private final List<MetricToRetain> additionalMetricsToRetainV2;
    private final List<Tag> tags;

    private CreateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
        this.tags = builder.tags;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public boolean hasBehaviors() {
        return this.behaviors != null && !(this.behaviors instanceof SdkAutoConstructList);
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(this.alertTargets);
    }

    public boolean hasAlertTargets() {
        return this.alertTargets != null && !(this.alertTargets instanceof SdkAutoConstructMap);
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    public boolean hasAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain != null && !(this.additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    public List<String> additionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    public boolean hasAdditionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2 != null && !(this.additionalMetricsToRetainV2 instanceof SdkAutoConstructList);
    }

    public List<MetricToRetain> additionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBehaviors() ? this.behaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlertTargets() ? this.alertTargetsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMetricsToRetain() ? this.additionalMetricsToRetain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMetricsToRetainV2() ? this.additionalMetricsToRetainV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && this.hasBehaviors() == other.hasBehaviors() && Objects.equals(this.behaviors(), other.behaviors()) && this.hasAlertTargets() == other.hasAlertTargets() && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings()) && this.hasAdditionalMetricsToRetain() == other.hasAdditionalMetricsToRetain() && Objects.equals(this.additionalMetricsToRetain(), other.additionalMetricsToRetain()) && this.hasAdditionalMetricsToRetainV2() == other.hasAdditionalMetricsToRetainV2() && Objects.equals(this.additionalMetricsToRetainV2(), other.additionalMetricsToRetainV2()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.hasBehaviors() ? this.behaviors() : null).add("AlertTargets", this.hasAlertTargets() ? this.alertTargetsAsStrings() : null).add("AdditionalMetricsToRetain", this.hasAdditionalMetricsToRetain() ? this.additionalMetricsToRetain() : null).add("AdditionalMetricsToRetainV2", this.hasAdditionalMetricsToRetainV2() ? this.additionalMetricsToRetainV2() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
            case "additionalMetricsToRetain": {
                return Optional.ofNullable(clazz.cast(this.additionalMetricsToRetain()));
            }
            case "additionalMetricsToRetainV2": {
                return Optional.ofNullable(clazz.cast(this.additionalMetricsToRetainV2()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileRequest, T> g) {
        return obj -> g.apply((CreateSecurityProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();
        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();
        private List<MetricToRetain> additionalMetricsToRetainV2 = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
            this.additionalMetricsToRetain(model.additionalMetricsToRetain);
            this.additionalMetricsToRetainV2(model.additionalMetricsToRetainV2);
            this.tags(model.tags);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            if (this.behaviors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            if (this.alertTargets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Collection<String> getAdditionalMetricsToRetain() {
            if (this.additionalMetricsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalMetricsToRetain;
        }

        @Override
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetain(String ... additionalMetricsToRetain) {
            this.additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        public final Collection<MetricToRetain.Builder> getAdditionalMetricsToRetainV2() {
            if (this.additionalMetricsToRetainV2 instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalMetricsToRetainV2 != null ? (Collection)this.additionalMetricsToRetainV2.stream().map(MetricToRetain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copy(additionalMetricsToRetainV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(MetricToRetain ... additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2(Arrays.asList(additionalMetricsToRetainV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder> ... additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2(Stream.of(additionalMetricsToRetainV2).map(c -> (MetricToRetain)((MetricToRetain.Builder)MetricToRetain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalMetricsToRetainV2(Collection<MetricToRetain.BuilderImpl> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copyFromBuilder(additionalMetricsToRetainV2);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityProfileRequest build() {
            return new CreateSecurityProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder additionalMetricsToRetain(Collection<String> var1);

        public Builder additionalMetricsToRetain(String ... var1);

        public Builder additionalMetricsToRetainV2(Collection<MetricToRetain> var1);

        public Builder additionalMetricsToRetainV2(MetricToRetain ... var1);

        public Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

