/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AssetPropertyValue;
import software.amazon.awssdk.services.iot.model.AssetPropertyValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAssetPropertyValueEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutAssetPropertyValueEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(PutAssetPropertyValueEntry.getter(PutAssetPropertyValueEntry::entryId)).setter(PutAssetPropertyValueEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(PutAssetPropertyValueEntry.getter(PutAssetPropertyValueEntry::assetId)).setter(PutAssetPropertyValueEntry.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(PutAssetPropertyValueEntry.getter(PutAssetPropertyValueEntry::propertyId)).setter(PutAssetPropertyValueEntry.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(PutAssetPropertyValueEntry.getter(PutAssetPropertyValueEntry::propertyAlias)).setter(PutAssetPropertyValueEntry.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()}).build();
    private static final SdkField<List<AssetPropertyValue>> PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyValues").getter(PutAssetPropertyValueEntry.getter(PutAssetPropertyValueEntry::propertyValues)).setter(PutAssetPropertyValueEntry.setter(Builder::propertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetPropertyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final List<AssetPropertyValue> propertyValues;

    private PutAssetPropertyValueEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyValues = builder.propertyValues;
    }

    public String entryId() {
        return this.entryId;
    }

    public String assetId() {
        return this.assetId;
    }

    public String propertyId() {
        return this.propertyId;
    }

    public String propertyAlias() {
        return this.propertyAlias;
    }

    public boolean hasPropertyValues() {
        return this.propertyValues != null && !(this.propertyValues instanceof SdkAutoConstructList);
    }

    public List<AssetPropertyValue> propertyValues() {
        return this.propertyValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyValues() ? this.propertyValues() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAssetPropertyValueEntry)) {
            return false;
        }
        PutAssetPropertyValueEntry other = (PutAssetPropertyValueEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && this.hasPropertyValues() == other.hasPropertyValues() && Objects.equals(this.propertyValues(), other.propertyValues());
    }

    public String toString() {
        return ToString.builder((String)"PutAssetPropertyValueEntry").add("EntryId", (Object)this.entryId()).add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("PropertyValues", this.hasPropertyValues() ? this.propertyValues() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "propertyValues": {
                return Optional.ofNullable(clazz.cast(this.propertyValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAssetPropertyValueEntry, T> g) {
        return obj -> g.apply((PutAssetPropertyValueEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private List<AssetPropertyValue> propertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAssetPropertyValueEntry model) {
            this.entryId(model.entryId);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.propertyValues(model.propertyValues);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final Collection<AssetPropertyValue.Builder> getPropertyValues() {
            if (this.propertyValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertyValues != null ? (Collection)this.propertyValues.stream().map(AssetPropertyValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propertyValues(Collection<AssetPropertyValue> propertyValues) {
            this.propertyValues = AssetPropertyValueListCopier.copy(propertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(AssetPropertyValue ... propertyValues) {
            this.propertyValues(Arrays.asList(propertyValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(Consumer<AssetPropertyValue.Builder> ... propertyValues) {
            this.propertyValues(Stream.of(propertyValues).map(c -> (AssetPropertyValue)((AssetPropertyValue.Builder)AssetPropertyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyValues(Collection<AssetPropertyValue.BuilderImpl> propertyValues) {
            this.propertyValues = AssetPropertyValueListCopier.copyFromBuilder(propertyValues);
        }

        public PutAssetPropertyValueEntry build() {
            return new PutAssetPropertyValueEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutAssetPropertyValueEntry> {
        public Builder entryId(String var1);

        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder propertyValues(Collection<AssetPropertyValue> var1);

        public Builder propertyValues(AssetPropertyValue ... var1);

        public Builder propertyValues(Consumer<AssetPropertyValue.Builder> ... var1);
    }
}

