/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that determine when and how a job abort takes place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbortConfig implements SdkPojo, Serializable, ToCopyableBuilder<AbortConfig.Builder, AbortConfig> {
    private static final SdkField<List<AbortCriteria>> CRITERIA_LIST_FIELD = SdkField
            .<List<AbortCriteria>> builder(MarshallingType.LIST)
            .memberName("criteriaList")
            .getter(getter(AbortConfig::criteriaList))
            .setter(setter(Builder::criteriaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteriaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AbortCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(AbortCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AbortCriteria> criteriaList;

    private AbortConfig(BuilderImpl builder) {
        this.criteriaList = builder.criteriaList;
    }

    /**
     * Returns true if the CriteriaList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCriteriaList() {
        return criteriaList != null && !(criteriaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of criteria that determine when and how to abort the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCriteriaList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of criteria that determine when and how to abort the job.
     */
    public List<AbortCriteria> criteriaList() {
        return criteriaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCriteriaList() ? criteriaList() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortConfig)) {
            return false;
        }
        AbortConfig other = (AbortConfig) obj;
        return hasCriteriaList() == other.hasCriteriaList() && Objects.equals(criteriaList(), other.criteriaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AbortConfig").add("CriteriaList", hasCriteriaList() ? criteriaList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "criteriaList":
            return Optional.ofNullable(clazz.cast(criteriaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbortConfig, T> g) {
        return obj -> g.apply((AbortConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbortConfig> {
        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * 
         * @param criteriaList
         *        The list of criteria that determine when and how to abort the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteriaList(Collection<AbortCriteria> criteriaList);

        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * 
         * @param criteriaList
         *        The list of criteria that determine when and how to abort the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteriaList(AbortCriteria... criteriaList);

        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AbortCriteria>.Builder} avoiding the need
         * to create one manually via {@link List<AbortCriteria>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AbortCriteria>.Builder#build()} is called immediately and
         * its result is passed to {@link #criteriaList(List<AbortCriteria>)}.
         * 
         * @param criteriaList
         *        a consumer that will call methods on {@link List<AbortCriteria>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteriaList(List<AbortCriteria>)
         */
        Builder criteriaList(Consumer<AbortCriteria.Builder>... criteriaList);
    }

    static final class BuilderImpl implements Builder {
        private List<AbortCriteria> criteriaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AbortConfig model) {
            criteriaList(model.criteriaList);
        }

        public final Collection<AbortCriteria.Builder> getCriteriaList() {
            if (criteriaList instanceof SdkAutoConstructList) {
                return null;
            }
            return criteriaList != null ? criteriaList.stream().map(AbortCriteria::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder criteriaList(Collection<AbortCriteria> criteriaList) {
            this.criteriaList = AbortCriteriaListCopier.copy(criteriaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteriaList(AbortCriteria... criteriaList) {
            criteriaList(Arrays.asList(criteriaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteriaList(Consumer<AbortCriteria.Builder>... criteriaList) {
            criteriaList(Stream.of(criteriaList).map(c -> AbortCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCriteriaList(Collection<AbortCriteria.BuilderImpl> criteriaList) {
            this.criteriaList = AbortCriteriaListCopier.copyFromBuilder(criteriaList);
        }

        @Override
        public AbortConfig build() {
            return new AbortConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
