/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.EffectivePoliciesCopier;
import software.amazon.awssdk.services.iot.model.EffectivePolicy;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEffectivePoliciesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetEffectivePoliciesResponse> {
    private static final SdkField<List<EffectivePolicy>> EFFECTIVE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("effectivePolicies").getter(GetEffectivePoliciesResponse.getter(GetEffectivePoliciesResponse::effectivePolicies)).setter(GetEffectivePoliciesResponse.setter(Builder::effectivePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectivePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_POLICIES_FIELD));
    private final List<EffectivePolicy> effectivePolicies;

    private GetEffectivePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.effectivePolicies = builder.effectivePolicies;
    }

    public boolean hasEffectivePolicies() {
        return this.effectivePolicies != null && !(this.effectivePolicies instanceof SdkAutoConstructList);
    }

    public List<EffectivePolicy> effectivePolicies() {
        return this.effectivePolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectivePolicies() ? this.effectivePolicies() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePoliciesResponse)) {
            return false;
        }
        GetEffectivePoliciesResponse other = (GetEffectivePoliciesResponse)((Object)obj);
        return this.hasEffectivePolicies() == other.hasEffectivePolicies() && Objects.equals(this.effectivePolicies(), other.effectivePolicies());
    }

    public String toString() {
        return ToString.builder((String)"GetEffectivePoliciesResponse").add("EffectivePolicies", this.hasEffectivePolicies() ? this.effectivePolicies() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "effectivePolicies": {
                return Optional.ofNullable(clazz.cast(this.effectivePolicies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectivePoliciesResponse, T> g) {
        return obj -> g.apply((GetEffectivePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<EffectivePolicy> effectivePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePoliciesResponse model) {
            super(model);
            this.effectivePolicies(model.effectivePolicies);
        }

        public final Collection<EffectivePolicy.Builder> getEffectivePolicies() {
            if (this.effectivePolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.effectivePolicies != null ? (Collection)this.effectivePolicies.stream().map(EffectivePolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder effectivePolicies(Collection<EffectivePolicy> effectivePolicies) {
            this.effectivePolicies = EffectivePoliciesCopier.copy(effectivePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicies(EffectivePolicy ... effectivePolicies) {
            this.effectivePolicies(Arrays.asList(effectivePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicies(Consumer<EffectivePolicy.Builder> ... effectivePolicies) {
            this.effectivePolicies(Stream.of(effectivePolicies).map(c -> (EffectivePolicy)((EffectivePolicy.Builder)EffectivePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEffectivePolicies(Collection<EffectivePolicy.BuilderImpl> effectivePolicies) {
            this.effectivePolicies = EffectivePoliciesCopier.copyFromBuilder(effectivePolicies);
        }

        @Override
        public GetEffectivePoliciesResponse build() {
            return new GetEffectivePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEffectivePoliciesResponse> {
        public Builder effectivePolicies(Collection<EffectivePolicy> var1);

        public Builder effectivePolicies(EffectivePolicy ... var1);

        public Builder effectivePolicies(Consumer<EffectivePolicy.Builder> ... var1);
    }
}

