/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ThingGroupNameAndArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingGroupMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingGroupMetadata> {
    private static final SdkField<String> PARENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentGroupName").getter(ThingGroupMetadata.getter(ThingGroupMetadata::parentGroupName)).setter(ThingGroupMetadata.setter(Builder::parentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentGroupName").build()}).build();
    private static final SdkField<List<GroupNameAndArn>> ROOT_TO_PARENT_THING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rootToParentThingGroups").getter(ThingGroupMetadata.getter(ThingGroupMetadata::rootToParentThingGroups)).setter(ThingGroupMetadata.setter(Builder::rootToParentThingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootToParentThingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupNameAndArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(ThingGroupMetadata.getter(ThingGroupMetadata::creationDate)).setter(ThingGroupMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_GROUP_NAME_FIELD, ROOT_TO_PARENT_THING_GROUPS_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parentGroupName;
    private final List<GroupNameAndArn> rootToParentThingGroups;
    private final Instant creationDate;

    private ThingGroupMetadata(BuilderImpl builder) {
        this.parentGroupName = builder.parentGroupName;
        this.rootToParentThingGroups = builder.rootToParentThingGroups;
        this.creationDate = builder.creationDate;
    }

    public String parentGroupName() {
        return this.parentGroupName;
    }

    public boolean hasRootToParentThingGroups() {
        return this.rootToParentThingGroups != null && !(this.rootToParentThingGroups instanceof SdkAutoConstructList);
    }

    public List<GroupNameAndArn> rootToParentThingGroups() {
        return this.rootToParentThingGroups;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRootToParentThingGroups() ? this.rootToParentThingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupMetadata)) {
            return false;
        }
        ThingGroupMetadata other = (ThingGroupMetadata)obj;
        return Objects.equals(this.parentGroupName(), other.parentGroupName()) && this.hasRootToParentThingGroups() == other.hasRootToParentThingGroups() && Objects.equals(this.rootToParentThingGroups(), other.rootToParentThingGroups()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"ThingGroupMetadata").add("ParentGroupName", (Object)this.parentGroupName()).add("RootToParentThingGroups", this.hasRootToParentThingGroups() ? this.rootToParentThingGroups() : null).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentGroupName": {
                return Optional.ofNullable(clazz.cast(this.parentGroupName()));
            }
            case "rootToParentThingGroups": {
                return Optional.ofNullable(clazz.cast(this.rootToParentThingGroups()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupMetadata, T> g) {
        return obj -> g.apply((ThingGroupMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentGroupName;
        private List<GroupNameAndArn> rootToParentThingGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupMetadata model) {
            this.parentGroupName(model.parentGroupName);
            this.rootToParentThingGroups(model.rootToParentThingGroups);
            this.creationDate(model.creationDate);
        }

        public final String getParentGroupName() {
            return this.parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        public final Collection<GroupNameAndArn.Builder> getRootToParentThingGroups() {
            if (this.rootToParentThingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rootToParentThingGroups != null ? (Collection)this.rootToParentThingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copy(rootToParentThingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(GroupNameAndArn ... rootToParentThingGroups) {
            this.rootToParentThingGroups(Arrays.asList(rootToParentThingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder> ... rootToParentThingGroups) {
            this.rootToParentThingGroups(Stream.of(rootToParentThingGroups).map(c -> (GroupNameAndArn)((GroupNameAndArn.Builder)GroupNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRootToParentThingGroups(Collection<GroupNameAndArn.BuilderImpl> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(rootToParentThingGroups);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public ThingGroupMetadata build() {
            return new ThingGroupMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingGroupMetadata> {
        public Builder parentGroupName(String var1);

        public Builder rootToParentThingGroups(Collection<GroupNameAndArn> var1);

        public Builder rootToParentThingGroups(GroupNameAndArn ... var1);

        public Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder> ... var1);

        public Builder creationDate(Instant var1);
    }
}

