/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters used when defining a mitigation action that move a set of things to a thing group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddThingsToThingGroupParams implements SdkPojo, Serializable,
        ToCopyableBuilder<AddThingsToThingGroupParams.Builder, AddThingsToThingGroupParams> {
    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("thingGroupNames")
            .getter(getter(AddThingsToThingGroupParams::thingGroupNames))
            .setter(setter(Builder::thingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overrideDynamicGroups").getter(getter(AddThingsToThingGroupParams::overrideDynamicGroups))
            .setter(setter(Builder::overrideDynamicGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAMES_FIELD,
            OVERRIDE_DYNAMIC_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> thingGroupNames;

    private final Boolean overrideDynamicGroups;

    private AddThingsToThingGroupParams(BuilderImpl builder) {
        this.thingGroupNames = builder.thingGroupNames;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    /**
     * Returns true if the ThingGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasThingGroupNames() {
        return thingGroupNames != null && !(thingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing
     * to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThingGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of groups to which you want to add the things that triggered the mitigation action. You can add
     *         a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
     *         hierarchy.
     */
    public List<String> thingGroupNames() {
        return thingGroupNames;
    }

    /**
     * <p>
     * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are
     * part of one or more dynamic thing groups.
     * </p>
     * 
     * @return Specifies if this mitigation action can move the things that triggered the mitigation action even if they
     *         are part of one or more dynamic thing groups.
     */
    public Boolean overrideDynamicGroups() {
        return overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroupNames() ? thingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overrideDynamicGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddThingsToThingGroupParams)) {
            return false;
        }
        AddThingsToThingGroupParams other = (AddThingsToThingGroupParams) obj;
        return hasThingGroupNames() == other.hasThingGroupNames() && Objects.equals(thingGroupNames(), other.thingGroupNames())
                && Objects.equals(overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddThingsToThingGroupParams")
                .add("ThingGroupNames", hasThingGroupNames() ? thingGroupNames() : null)
                .add("OverrideDynamicGroups", overrideDynamicGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupNames":
            return Optional.ofNullable(clazz.cast(thingGroupNames()));
        case "overrideDynamicGroups":
            return Optional.ofNullable(clazz.cast(overrideDynamicGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddThingsToThingGroupParams, T> g) {
        return obj -> g.apply((AddThingsToThingGroupParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddThingsToThingGroupParams> {
        /**
         * <p>
         * The list of groups to which you want to add the things that triggered the mitigation action. You can add a
         * thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         * </p>
         * 
         * @param thingGroupNames
         *        The list of groups to which you want to add the things that triggered the mitigation action. You can
         *        add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
         *        hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(Collection<String> thingGroupNames);

        /**
         * <p>
         * The list of groups to which you want to add the things that triggered the mitigation action. You can add a
         * thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         * </p>
         * 
         * @param thingGroupNames
         *        The list of groups to which you want to add the things that triggered the mitigation action. You can
         *        add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
         *        hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(String... thingGroupNames);

        /**
         * <p>
         * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are
         * part of one or more dynamic thing groups.
         * </p>
         * 
         * @param overrideDynamicGroups
         *        Specifies if this mitigation action can move the things that triggered the mitigation action even if
         *        they are part of one or more dynamic thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideDynamicGroups(Boolean overrideDynamicGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(AddThingsToThingGroupParams model) {
            thingGroupNames(model.thingGroupNames);
            overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final Collection<String> getThingGroupNames() {
            if (thingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroupNames;
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String... thingGroupNames) {
            thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
        }

        public final Boolean getOverrideDynamicGroups() {
            return overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public AddThingsToThingGroupParams build() {
            return new AddThingsToThingGroupParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
