/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the certificate chain being used when code signing a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigningCertificateChain implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSigningCertificateChain.Builder, CodeSigningCertificateChain> {
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(CodeSigningCertificateChain::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> INLINE_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inlineDocument").getter(getter(CodeSigningCertificateChain::inlineDocument))
            .setter(setter(Builder::inlineDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_NAME_FIELD,
            INLINE_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateName;

    private final String inlineDocument;

    private CodeSigningCertificateChain(BuilderImpl builder) {
        this.certificateName = builder.certificateName;
        this.inlineDocument = builder.inlineDocument;
    }

    /**
     * <p>
     * The name of the certificate.
     * </p>
     * 
     * @return The name of the certificate.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * A base64 encoded binary representation of the code signing certificate chain.
     * </p>
     * 
     * @return A base64 encoded binary representation of the code signing certificate chain.
     */
    public String inlineDocument() {
        return inlineDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(inlineDocument());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningCertificateChain)) {
            return false;
        }
        CodeSigningCertificateChain other = (CodeSigningCertificateChain) obj;
        return Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(inlineDocument(), other.inlineDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CodeSigningCertificateChain").add("CertificateName", certificateName())
                .add("InlineDocument", inlineDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "inlineDocument":
            return Optional.ofNullable(clazz.cast(inlineDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeSigningCertificateChain, T> g) {
        return obj -> g.apply((CodeSigningCertificateChain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSigningCertificateChain> {
        /**
         * <p>
         * The name of the certificate.
         * </p>
         * 
         * @param certificateName
         *        The name of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * A base64 encoded binary representation of the code signing certificate chain.
         * </p>
         * 
         * @param inlineDocument
         *        A base64 encoded binary representation of the code signing certificate chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineDocument(String inlineDocument);
    }

    static final class BuilderImpl implements Builder {
        private String certificateName;

        private String inlineDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningCertificateChain model) {
            certificateName(model.certificateName);
            inlineDocument(model.inlineDocument);
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getInlineDocument() {
            return inlineDocument;
        }

        @Override
        public final Builder inlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
            return this;
        }

        public final void setInlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
        }

        @Override
        public CodeSigningCertificateChain build() {
            return new CodeSigningCertificateChain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
