/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A statistical ranking (percentile) that indicates a threshold value by which a behavior is determined to be in
 * compliance or in violation of the behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticalThreshold implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticalThreshold.Builder, StatisticalThreshold> {
    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statistic").getter(getter(StatisticalThreshold::statistic)).setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statistic;

    private StatisticalThreshold(BuilderImpl builder) {
        this.statistic = builder.statistic;
    }

    /**
     * <p>
     * The percentile that resolves to a threshold value by which compliance with a behavior is determined. Metrics are
     * collected over the specified period (<code>durationSeconds</code>) from all reporting devices in your account and
     * statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the
     * accumulated measurements from the device fall above or below (<code>comparisonOperator</code>) the value
     * associated with the percentile specified, then the device is considered to be in compliance with the behavior,
     * otherwise a violation occurs.
     * </p>
     * 
     * @return The percentile that resolves to a threshold value by which compliance with a behavior is determined.
     *         Metrics are collected over the specified period (<code>durationSeconds</code>) from all reporting devices
     *         in your account and statistical ranks are calculated. Then, the measurements from a device are collected
     *         over the same period. If the accumulated measurements from the device fall above or below (
     *         <code>comparisonOperator</code>) the value associated with the percentile specified, then the device is
     *         considered to be in compliance with the behavior, otherwise a violation occurs.
     */
    public String statistic() {
        return statistic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statistic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticalThreshold)) {
            return false;
        }
        StatisticalThreshold other = (StatisticalThreshold) obj;
        return Objects.equals(statistic(), other.statistic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StatisticalThreshold").add("Statistic", statistic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statistic":
            return Optional.ofNullable(clazz.cast(statistic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatisticalThreshold, T> g) {
        return obj -> g.apply((StatisticalThreshold) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticalThreshold> {
        /**
         * <p>
         * The percentile that resolves to a threshold value by which compliance with a behavior is determined. Metrics
         * are collected over the specified period (<code>durationSeconds</code>) from all reporting devices in your
         * account and statistical ranks are calculated. Then, the measurements from a device are collected over the
         * same period. If the accumulated measurements from the device fall above or below (
         * <code>comparisonOperator</code>) the value associated with the percentile specified, then the device is
         * considered to be in compliance with the behavior, otherwise a violation occurs.
         * </p>
         * 
         * @param statistic
         *        The percentile that resolves to a threshold value by which compliance with a behavior is determined.
         *        Metrics are collected over the specified period (<code>durationSeconds</code>) from all reporting
         *        devices in your account and statistical ranks are calculated. Then, the measurements from a device are
         *        collected over the same period. If the accumulated measurements from the device fall above or below (
         *        <code>comparisonOperator</code>) the value associated with the percentile specified, then the device
         *        is considered to be in compliance with the behavior, otherwise a violation occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistic(String statistic);
    }

    static final class BuilderImpl implements Builder {
        private String statistic;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticalThreshold model) {
            statistic(model.statistic);
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public StatisticalThreshold build() {
            return new StatisticalThreshold(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
