/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the topic rule destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRuleDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRuleDestinationConfiguration.Builder, TopicRuleDestinationConfiguration> {
    private static final SdkField<HttpUrlDestinationConfiguration> HTTP_URL_CONFIGURATION_FIELD = SdkField
            .<HttpUrlDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("httpUrlConfiguration")
            .getter(getter(TopicRuleDestinationConfiguration::httpUrlConfiguration))
            .setter(setter(Builder::httpUrlConfiguration)).constructor(HttpUrlDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlConfiguration").build())
            .build();

    private static final SdkField<VpcDestinationConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(TopicRuleDestinationConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_URL_CONFIGURATION_FIELD,
            VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final HttpUrlDestinationConfiguration httpUrlConfiguration;

    private final VpcDestinationConfiguration vpcConfiguration;

    private TopicRuleDestinationConfiguration(BuilderImpl builder) {
        this.httpUrlConfiguration = builder.httpUrlConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * Configuration of the HTTP URL.
     * </p>
     * 
     * @return Configuration of the HTTP URL.
     */
    public HttpUrlDestinationConfiguration httpUrlConfiguration() {
        return httpUrlConfiguration;
    }

    /**
     * <p>
     * Configuration of the virtual private cloud (VPC) connection.
     * </p>
     * 
     * @return Configuration of the virtual private cloud (VPC) connection.
     */
    public VpcDestinationConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpUrlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationConfiguration)) {
            return false;
        }
        TopicRuleDestinationConfiguration other = (TopicRuleDestinationConfiguration) obj;
        return Objects.equals(httpUrlConfiguration(), other.httpUrlConfiguration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TopicRuleDestinationConfiguration").add("HttpUrlConfiguration", httpUrlConfiguration())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpUrlConfiguration":
            return Optional.ofNullable(clazz.cast(httpUrlConfiguration()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationConfiguration, T> g) {
        return obj -> g.apply((TopicRuleDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRuleDestinationConfiguration> {
        /**
         * <p>
         * Configuration of the HTTP URL.
         * </p>
         * 
         * @param httpUrlConfiguration
         *        Configuration of the HTTP URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpUrlConfiguration(HttpUrlDestinationConfiguration httpUrlConfiguration);

        /**
         * <p>
         * Configuration of the HTTP URL.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpUrlDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link HttpUrlDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpUrlDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #httpUrlConfiguration(HttpUrlDestinationConfiguration)}.
         * 
         * @param httpUrlConfiguration
         *        a consumer that will call methods on {@link HttpUrlDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpUrlConfiguration(HttpUrlDestinationConfiguration)
         */
        default Builder httpUrlConfiguration(Consumer<HttpUrlDestinationConfiguration.Builder> httpUrlConfiguration) {
            return httpUrlConfiguration(HttpUrlDestinationConfiguration.builder().applyMutation(httpUrlConfiguration).build());
        }

        /**
         * <p>
         * Configuration of the virtual private cloud (VPC) connection.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration of the virtual private cloud (VPC) connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcDestinationConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration of the virtual private cloud (VPC) connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcDestinationConfiguration.Builder} avoiding
         * the need to create one manually via {@link VpcDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfiguration(VpcDestinationConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcDestinationConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcDestinationConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcDestinationConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpUrlDestinationConfiguration httpUrlConfiguration;

        private VpcDestinationConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationConfiguration model) {
            httpUrlConfiguration(model.httpUrlConfiguration);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final HttpUrlDestinationConfiguration.Builder getHttpUrlConfiguration() {
            return httpUrlConfiguration != null ? httpUrlConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder httpUrlConfiguration(HttpUrlDestinationConfiguration httpUrlConfiguration) {
            this.httpUrlConfiguration = httpUrlConfiguration;
            return this;
        }

        public final void setHttpUrlConfiguration(HttpUrlDestinationConfiguration.BuilderImpl httpUrlConfiguration) {
            this.httpUrlConfiguration = httpUrlConfiguration != null ? httpUrlConfiguration.build() : null;
        }

        public final VpcDestinationConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcDestinationConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final void setVpcConfiguration(VpcDestinationConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public TopicRuleDestinationConfiguration build() {
            return new TopicRuleDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
