/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMitigationActionRequest extends IotRequest implements
        ToCopyableBuilder<UpdateMitigationActionRequest.Builder, UpdateMitigationActionRequest> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(UpdateMitigationActionRequest::actionName))
            .setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateMitigationActionRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<MitigationActionParams> ACTION_PARAMS_FIELD = SdkField
            .<MitigationActionParams> builder(MarshallingType.SDK_POJO).memberName("actionParams")
            .getter(getter(UpdateMitigationActionRequest::actionParams)).setter(setter(Builder::actionParams))
            .constructor(MitigationActionParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionParams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ROLE_ARN_FIELD, ACTION_PARAMS_FIELD));

    private final String actionName;

    private final String roleArn;

    private final MitigationActionParams actionParams;

    private UpdateMitigationActionRequest(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.roleArn = builder.roleArn;
        this.actionParams = builder.actionParams;
    }

    /**
     * <p>
     * The friendly name for the mitigation action. You cannot change the name by using
     * <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with the new
     * name.
     * </p>
     * 
     * @return The friendly name for the mitigation action. You cannot change the name by using
     *         <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with the
     *         new name.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The ARN of the IAM role that is used to apply the mitigation action.
     * </p>
     * 
     * @return The ARN of the IAM role that is used to apply the mitigation action.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Defines the type of action and the parameters for that action.
     * </p>
     * 
     * @return Defines the type of action and the parameters for that action.
     */
    public MitigationActionParams actionParams() {
        return actionParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionParams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMitigationActionRequest)) {
            return false;
        }
        UpdateMitigationActionRequest other = (UpdateMitigationActionRequest) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(actionParams(), other.actionParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateMitigationActionRequest").add("ActionName", actionName()).add("RoleArn", roleArn())
                .add("ActionParams", actionParams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "actionParams":
            return Optional.ofNullable(clazz.cast(actionParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMitigationActionRequest, T> g) {
        return obj -> g.apply((UpdateMitigationActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMitigationActionRequest> {
        /**
         * <p>
         * The friendly name for the mitigation action. You cannot change the name by using
         * <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with the new
         * name.
         * </p>
         * 
         * @param actionName
         *        The friendly name for the mitigation action. You cannot change the name by using
         *        <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with
         *        the new name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The ARN of the IAM role that is used to apply the mitigation action.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that is used to apply the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Defines the type of action and the parameters for that action.
         * </p>
         * 
         * @param actionParams
         *        Defines the type of action and the parameters for that action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionParams(MitigationActionParams actionParams);

        /**
         * <p>
         * Defines the type of action and the parameters for that action.
         * </p>
         * This is a convenience that creates an instance of the {@link MitigationActionParams.Builder} avoiding the
         * need to create one manually via {@link MitigationActionParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link MitigationActionParams.Builder#build()} is called immediately and
         * its result is passed to {@link #actionParams(MitigationActionParams)}.
         * 
         * @param actionParams
         *        a consumer that will call methods on {@link MitigationActionParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionParams(MitigationActionParams)
         */
        default Builder actionParams(Consumer<MitigationActionParams.Builder> actionParams) {
            return actionParams(MitigationActionParams.builder().applyMutation(actionParams).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String actionName;

        private String roleArn;

        private MitigationActionParams actionParams;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMitigationActionRequest model) {
            super(model);
            actionName(model.actionName);
            roleArn(model.roleArn);
            actionParams(model.actionParams);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MitigationActionParams.Builder getActionParams() {
            return actionParams != null ? actionParams.toBuilder() : null;
        }

        @Override
        public final Builder actionParams(MitigationActionParams actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        public final void setActionParams(MitigationActionParams.BuilderImpl actionParams) {
            this.actionParams = actionParams != null ? actionParams.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMitigationActionRequest build() {
            return new UpdateMitigationActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
