/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a violation event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViolationEventAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ViolationEventAdditionalInfo.Builder, ViolationEventAdditionalInfo> {
    private static final SdkField<String> CONFIDENCE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confidenceLevel").getter(getter(ViolationEventAdditionalInfo::confidenceLevelAsString))
            .setter(setter(Builder::confidenceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String confidenceLevel;

    private ViolationEventAdditionalInfo(BuilderImpl builder) {
        this.confidenceLevel = builder.confidenceLevel;
    }

    /**
     * <p>
     * The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
     * <code>High</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidenceLevel}
     * will return {@link ConfidenceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #confidenceLevelAsString}.
     * </p>
     * 
     * @return The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
     *         <code>High</code>.
     * @see ConfidenceLevel
     */
    public ConfidenceLevel confidenceLevel() {
        return ConfidenceLevel.fromValue(confidenceLevel);
    }

    /**
     * <p>
     * The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
     * <code>High</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidenceLevel}
     * will return {@link ConfidenceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #confidenceLevelAsString}.
     * </p>
     * 
     * @return The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
     *         <code>High</code>.
     * @see ConfidenceLevel
     */
    public String confidenceLevelAsString() {
        return confidenceLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confidenceLevelAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationEventAdditionalInfo)) {
            return false;
        }
        ViolationEventAdditionalInfo other = (ViolationEventAdditionalInfo) obj;
        return Objects.equals(confidenceLevelAsString(), other.confidenceLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ViolationEventAdditionalInfo").add("ConfidenceLevel", confidenceLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "confidenceLevel":
            return Optional.ofNullable(clazz.cast(confidenceLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViolationEventAdditionalInfo, T> g) {
        return obj -> g.apply((ViolationEventAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViolationEventAdditionalInfo> {
        /**
         * <p>
         * The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
         * <code>High</code>.
         * </p>
         * 
         * @param confidenceLevel
         *        The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
         *        <code>High</code>.
         * @see ConfidenceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceLevel
         */
        Builder confidenceLevel(String confidenceLevel);

        /**
         * <p>
         * The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
         * <code>High</code>.
         * </p>
         * 
         * @param confidenceLevel
         *        The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or
         *        <code>High</code>.
         * @see ConfidenceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceLevel
         */
        Builder confidenceLevel(ConfidenceLevel confidenceLevel);
    }

    static final class BuilderImpl implements Builder {
        private String confidenceLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationEventAdditionalInfo model) {
            confidenceLevel(model.confidenceLevel);
        }

        public final String getConfidenceLevel() {
            return confidenceLevel;
        }

        @Override
        public final Builder confidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            return this;
        }

        @Override
        public final Builder confidenceLevel(ConfidenceLevel confidenceLevel) {
            this.confidenceLevel(confidenceLevel == null ? null : confidenceLevel.toString());
            return this;
        }

        public final void setConfidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        @Override
        public ViolationEventAdditionalInfo build() {
            return new ViolationEventAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
