/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Device Defender security profile behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Behavior implements SdkPojo, Serializable, ToCopyableBuilder<Behavior.Builder, Behavior> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Behavior::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("metric")
            .getter(getter(Behavior::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()).build();

    private static final SdkField<MetricDimension> METRIC_DIMENSION_FIELD = SdkField
            .<MetricDimension> builder(MarshallingType.SDK_POJO).memberName("metricDimension")
            .getter(getter(Behavior::metricDimension)).setter(setter(Builder::metricDimension))
            .constructor(MetricDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDimension").build()).build();

    private static final SdkField<BehaviorCriteria> CRITERIA_FIELD = SdkField
            .<BehaviorCriteria> builder(MarshallingType.SDK_POJO).memberName("criteria").getter(getter(Behavior::criteria))
            .setter(setter(Builder::criteria)).constructor(BehaviorCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()).build();

    private static final SdkField<Boolean> SUPPRESS_ALERTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("suppressAlerts").getter(getter(Behavior::suppressAlerts)).setter(setter(Builder::suppressAlerts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressAlerts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_FIELD,
            METRIC_DIMENSION_FIELD, CRITERIA_FIELD, SUPPRESS_ALERTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String metric;

    private final MetricDimension metricDimension;

    private final BehaviorCriteria criteria;

    private final Boolean suppressAlerts;

    private Behavior(BuilderImpl builder) {
        this.name = builder.name;
        this.metric = builder.metric;
        this.metricDimension = builder.metricDimension;
        this.criteria = builder.criteria;
        this.suppressAlerts = builder.suppressAlerts;
    }

    /**
     * <p>
     * The name you've given to the behavior.
     * </p>
     * 
     * @return The name you've given to the behavior.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * What is measured by the behavior.
     * </p>
     * 
     * @return What is measured by the behavior.
     */
    public String metric() {
        return metric;
    }

    /**
     * <p>
     * The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension, you can
     * narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the
     * dimension. This can't be used with custom metrics.
     * </p>
     * 
     * @return The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension,
     *         you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern
     *         specified in the dimension. This can't be used with custom metrics.
     */
    public MetricDimension metricDimension() {
        return metricDimension;
    }

    /**
     * <p>
     * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
     * </p>
     * 
     * @return The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
     */
    public BehaviorCriteria criteria() {
        return criteria;
    }

    /**
     * <p>
     * Suppresses alerts.
     * </p>
     * 
     * @return Suppresses alerts.
     */
    public Boolean suppressAlerts() {
        return suppressAlerts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(metricDimension());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(suppressAlerts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Behavior)) {
            return false;
        }
        Behavior other = (Behavior) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(metric(), other.metric())
                && Objects.equals(metricDimension(), other.metricDimension()) && Objects.equals(criteria(), other.criteria())
                && Objects.equals(suppressAlerts(), other.suppressAlerts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Behavior").add("Name", name()).add("Metric", metric()).add("MetricDimension", metricDimension())
                .add("Criteria", criteria()).add("SuppressAlerts", suppressAlerts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "metricDimension":
            return Optional.ofNullable(clazz.cast(metricDimension()));
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "suppressAlerts":
            return Optional.ofNullable(clazz.cast(suppressAlerts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Behavior, T> g) {
        return obj -> g.apply((Behavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Behavior> {
        /**
         * <p>
         * The name you've given to the behavior.
         * </p>
         * 
         * @param name
         *        The name you've given to the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * What is measured by the behavior.
         * </p>
         * 
         * @param metric
         *        What is measured by the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension, you
         * can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in
         * the dimension. This can't be used with custom metrics.
         * </p>
         * 
         * @param metricDimension
         *        The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension,
         *        you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern
         *        specified in the dimension. This can't be used with custom metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimension(MetricDimension metricDimension);

        /**
         * <p>
         * The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension, you
         * can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in
         * the dimension. This can't be used with custom metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricDimension.Builder} avoiding the need to
         * create one manually via {@link MetricDimension#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #metricDimension(MetricDimension)}.
         * 
         * @param metricDimension
         *        a consumer that will call methods on {@link MetricDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDimension(MetricDimension)
         */
        default Builder metricDimension(Consumer<MetricDimension.Builder> metricDimension) {
            return metricDimension(MetricDimension.builder().applyMutation(metricDimension).build());
        }

        /**
         * <p>
         * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * </p>
         * 
         * @param criteria
         *        The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(BehaviorCriteria criteria);

        /**
         * <p>
         * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link BehaviorCriteria.Builder} avoiding the need to
         * create one manually via {@link BehaviorCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link BehaviorCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #criteria(BehaviorCriteria)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link BehaviorCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(BehaviorCriteria)
         */
        default Builder criteria(Consumer<BehaviorCriteria.Builder> criteria) {
            return criteria(BehaviorCriteria.builder().applyMutation(criteria).build());
        }

        /**
         * <p>
         * Suppresses alerts.
         * </p>
         * 
         * @param suppressAlerts
         *        Suppresses alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressAlerts(Boolean suppressAlerts);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String metric;

        private MetricDimension metricDimension;

        private BehaviorCriteria criteria;

        private Boolean suppressAlerts;

        private BuilderImpl() {
        }

        private BuilderImpl(Behavior model) {
            name(model.name);
            metric(model.metric);
            metricDimension(model.metricDimension);
            criteria(model.criteria);
            suppressAlerts(model.suppressAlerts);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetric() {
            return metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final MetricDimension.Builder getMetricDimension() {
            return metricDimension != null ? metricDimension.toBuilder() : null;
        }

        @Override
        public final Builder metricDimension(MetricDimension metricDimension) {
            this.metricDimension = metricDimension;
            return this;
        }

        public final void setMetricDimension(MetricDimension.BuilderImpl metricDimension) {
            this.metricDimension = metricDimension != null ? metricDimension.build() : null;
        }

        public final BehaviorCriteria.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        @Override
        public final Builder criteria(BehaviorCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final void setCriteria(BehaviorCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        public final Boolean getSuppressAlerts() {
            return suppressAlerts;
        }

        @Override
        public final Builder suppressAlerts(Boolean suppressAlerts) {
            this.suppressAlerts = suppressAlerts;
            return this;
        }

        public final void setSuppressAlerts(Boolean suppressAlerts) {
            this.suppressAlerts = suppressAlerts;
        }

        @Override
        public Behavior build() {
            return new Behavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
