/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomMetricRequest extends IotRequest implements
        ToCopyableBuilder<CreateCustomMetricRequest.Builder, CreateCustomMetricRequest> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(CreateCustomMetricRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("metricName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateCustomMetricRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricType").getter(getter(CreateCustomMetricRequest::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCustomMetricRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateCustomMetricRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            DISPLAY_NAME_FIELD, METRIC_TYPE_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String metricName;

    private final String displayName;

    private final String metricType;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateCustomMetricRequest(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.displayName = builder.displayName;
        this.metricType = builder.metricType;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't
     * begin with <code>aws:</code>. Cannot be updated once defined.
     * </p>
     * 
     * @return The name of the custom metric. This will be used in the metric report submitted from the device/thing.
     *         Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use
     * this name as the metric identifier in the device metric report. Can be updated once defined.
     * </p>
     * 
     * @return Field represents a friendly name in the console for the custom metric; it doesn't have to be unique.
     *         Don't use this name as the metric identifier in the device metric report. Can be updated once defined.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
     * <code>number-list</code>, and <code>number</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link CustomMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
     *         <code>number-list</code>, and <code>number</code>.
     * @see CustomMetricType
     */
    public CustomMetricType metricType() {
        return CustomMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
     * <code>number-list</code>, and <code>number</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link CustomMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
     *         <code>number-list</code>, and <code>number</code>.
     * @see CustomMetricType
     */
    public String metricTypeAsString() {
        return metricType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the custom metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata that can be used to manage the custom metric.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Each custom metric must have a unique client request token. If you try to create a new custom metric that already
     * exists with a different token, an exception occurs. If you omit this value, AWS SDKs will automatically generate
     * a unique client request.
     * </p>
     * 
     * @return Each custom metric must have a unique client request token. If you try to create a new custom metric that
     *         already exists with a different token, an exception occurs. If you omit this value, AWS SDKs will
     *         automatically generate a unique client request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomMetricRequest)) {
            return false;
        }
        CreateCustomMetricRequest other = (CreateCustomMetricRequest) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCustomMetricRequest").add("MetricName", metricName()).add("DisplayName", displayName())
                .add("MetricType", metricTypeAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "metricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomMetricRequest, T> g) {
        return obj -> g.apply((CreateCustomMetricRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomMetricRequest> {
        /**
         * <p>
         * The name of the custom metric. This will be used in the metric report submitted from the device/thing.
         * Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.
         * </p>
         * 
         * @param metricName
         *        The name of the custom metric. This will be used in the metric report submitted from the device/thing.
         *        Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't
         * use this name as the metric identifier in the device metric report. Can be updated once defined.
         * </p>
         * 
         * @param displayName
         *        Field represents a friendly name in the console for the custom metric; it doesn't have to be unique.
         *        Don't use this name as the metric identifier in the device metric report. Can be updated once defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
         * <code>number-list</code>, and <code>number</code>.
         * </p>
         * 
         * @param metricType
         *        The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
         *        <code>number-list</code>, and <code>number</code>.
         * @see CustomMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
         * <code>number-list</code>, and <code>number</code>.
         * </p>
         * 
         * @param metricType
         *        The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>,
         *        <code>number-list</code>, and <code>number</code>.
         * @see CustomMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMetricType
         */
        Builder metricType(CustomMetricType metricType);

        /**
         * <p>
         * Metadata that can be used to manage the custom metric.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the custom metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the custom metric.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the custom metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the custom metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Each custom metric must have a unique client request token. If you try to create a new custom metric that
         * already exists with a different token, an exception occurs. If you omit this value, AWS SDKs will
         * automatically generate a unique client request.
         * </p>
         * 
         * @param clientRequestToken
         *        Each custom metric must have a unique client request token. If you try to create a new custom metric
         *        that already exists with a different token, an exception occurs. If you omit this value, AWS SDKs will
         *        automatically generate a unique client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String metricName;

        private String displayName;

        private String metricType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomMetricRequest model) {
            super(model);
            metricName(model.metricName);
            displayName(model.displayName);
            metricType(model.metricType);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getMetricType() {
            return metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(CustomMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomMetricRequest build() {
            return new CreateCustomMetricRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
