/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the mitigation action tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectMitigationActionsTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectMitigationActionsTaskSummary.Builder, DetectMitigationActionsTaskSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(DetectMitigationActionsTaskSummary::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(DetectMitigationActionsTaskSummary::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("taskStartTime").getter(getter(DetectMitigationActionsTaskSummary::taskStartTime))
            .setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build()).build();

    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("taskEndTime").getter(getter(DetectMitigationActionsTaskSummary::taskEndTime))
            .setter(setter(Builder::taskEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskEndTime").build()).build();

    private static final SdkField<DetectMitigationActionsTaskTarget> TARGET_FIELD = SdkField
            .<DetectMitigationActionsTaskTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(DetectMitigationActionsTaskSummary::target)).setter(setter(Builder::target))
            .constructor(DetectMitigationActionsTaskTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<ViolationEventOccurrenceRange> VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD = SdkField
            .<ViolationEventOccurrenceRange> builder(MarshallingType.SDK_POJO)
            .memberName("violationEventOccurrenceRange")
            .getter(getter(DetectMitigationActionsTaskSummary::violationEventOccurrenceRange))
            .setter(setter(Builder::violationEventOccurrenceRange))
            .constructor(ViolationEventOccurrenceRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventOccurrenceRange")
                    .build()).build();

    private static final SdkField<Boolean> ONLY_ACTIVE_VIOLATIONS_INCLUDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("onlyActiveViolationsIncluded")
            .getter(getter(DetectMitigationActionsTaskSummary::onlyActiveViolationsIncluded))
            .setter(setter(Builder::onlyActiveViolationsIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlyActiveViolationsIncluded")
                    .build()).build();

    private static final SdkField<Boolean> SUPPRESSED_ALERTS_INCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("suppressedAlertsIncluded").getter(getter(DetectMitigationActionsTaskSummary::suppressedAlertsIncluded))
            .setter(setter(Builder::suppressedAlertsIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressedAlertsIncluded").build())
            .build();

    private static final SdkField<List<MitigationAction>> ACTIONS_DEFINITION_FIELD = SdkField
            .<List<MitigationAction>> builder(MarshallingType.LIST)
            .memberName("actionsDefinition")
            .getter(getter(DetectMitigationActionsTaskSummary::actionsDefinition))
            .setter(setter(Builder::actionsDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsDefinition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MitigationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(MitigationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DetectMitigationActionsTaskStatistics> TASK_STATISTICS_FIELD = SdkField
            .<DetectMitigationActionsTaskStatistics> builder(MarshallingType.SDK_POJO).memberName("taskStatistics")
            .getter(getter(DetectMitigationActionsTaskSummary::taskStatistics)).setter(setter(Builder::taskStatistics))
            .constructor(DetectMitigationActionsTaskStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            TASK_STATUS_FIELD, TASK_START_TIME_FIELD, TASK_END_TIME_FIELD, TARGET_FIELD, VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD,
            ONLY_ACTIVE_VIOLATIONS_INCLUDED_FIELD, SUPPRESSED_ALERTS_INCLUDED_FIELD, ACTIONS_DEFINITION_FIELD,
            TASK_STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String taskStatus;

    private final Instant taskStartTime;

    private final Instant taskEndTime;

    private final DetectMitigationActionsTaskTarget target;

    private final ViolationEventOccurrenceRange violationEventOccurrenceRange;

    private final Boolean onlyActiveViolationsIncluded;

    private final Boolean suppressedAlertsIncluded;

    private final List<MitigationAction> actionsDefinition;

    private final DetectMitigationActionsTaskStatistics taskStatistics;

    private DetectMitigationActionsTaskSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.taskStartTime = builder.taskStartTime;
        this.taskEndTime = builder.taskEndTime;
        this.target = builder.target;
        this.violationEventOccurrenceRange = builder.violationEventOccurrenceRange;
        this.onlyActiveViolationsIncluded = builder.onlyActiveViolationsIncluded;
        this.suppressedAlertsIncluded = builder.suppressedAlertsIncluded;
        this.actionsDefinition = builder.actionsDefinition;
        this.taskStatistics = builder.taskStatistics;
    }

    /**
     * <p>
     * The unique identifier of the task.
     * </p>
     * 
     * @return The unique identifier of the task.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link DetectMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see DetectMitigationActionsTaskStatus
     */
    public DetectMitigationActionsTaskStatus taskStatus() {
        return DetectMitigationActionsTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link DetectMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see DetectMitigationActionsTaskStatus
     */
    public String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The date the task started.
     * </p>
     * 
     * @return The date the task started.
     */
    public Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * The date the task ended.
     * </p>
     * 
     * @return The date the task ended.
     */
    public Instant taskEndTime() {
        return taskEndTime;
    }

    /**
     * <p>
     * Specifies the ML Detect findings to which the mitigation actions are applied.
     * </p>
     * 
     * @return Specifies the ML Detect findings to which the mitigation actions are applied.
     */
    public DetectMitigationActionsTaskTarget target() {
        return target;
    }

    /**
     * <p>
     * Specifies the time period of which violation events occurred between.
     * </p>
     * 
     * @return Specifies the time period of which violation events occurred between.
     */
    public ViolationEventOccurrenceRange violationEventOccurrenceRange() {
        return violationEventOccurrenceRange;
    }

    /**
     * <p>
     * Includes only active violations.
     * </p>
     * 
     * @return Includes only active violations.
     */
    public Boolean onlyActiveViolationsIncluded() {
        return onlyActiveViolationsIncluded;
    }

    /**
     * <p>
     * Includes suppressed alerts.
     * </p>
     * 
     * @return Includes suppressed alerts.
     */
    public Boolean suppressedAlertsIncluded() {
        return suppressedAlertsIncluded;
    }

    /**
     * Returns true if the ActionsDefinition property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasActionsDefinition() {
        return actionsDefinition != null && !(actionsDefinition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of the actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionsDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The definition of the actions.
     */
    public List<MitigationAction> actionsDefinition() {
        return actionsDefinition;
    }

    /**
     * <p>
     * The statistics of a mitigation action task.
     * </p>
     * 
     * @return The statistics of a mitigation action task.
     */
    public DetectMitigationActionsTaskStatistics taskStatistics() {
        return taskStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventOccurrenceRange());
        hashCode = 31 * hashCode + Objects.hashCode(onlyActiveViolationsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(suppressedAlertsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsDefinition() ? actionsDefinition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskStatistics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionsTaskSummary)) {
            return false;
        }
        DetectMitigationActionsTaskSummary other = (DetectMitigationActionsTaskSummary) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(taskStartTime(), other.taskStartTime()) && Objects.equals(taskEndTime(), other.taskEndTime())
                && Objects.equals(target(), other.target())
                && Objects.equals(violationEventOccurrenceRange(), other.violationEventOccurrenceRange())
                && Objects.equals(onlyActiveViolationsIncluded(), other.onlyActiveViolationsIncluded())
                && Objects.equals(suppressedAlertsIncluded(), other.suppressedAlertsIncluded())
                && hasActionsDefinition() == other.hasActionsDefinition()
                && Objects.equals(actionsDefinition(), other.actionsDefinition())
                && Objects.equals(taskStatistics(), other.taskStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectMitigationActionsTaskSummary").add("TaskId", taskId())
                .add("TaskStatus", taskStatusAsString()).add("TaskStartTime", taskStartTime()).add("TaskEndTime", taskEndTime())
                .add("Target", target()).add("ViolationEventOccurrenceRange", violationEventOccurrenceRange())
                .add("OnlyActiveViolationsIncluded", onlyActiveViolationsIncluded())
                .add("SuppressedAlertsIncluded", suppressedAlertsIncluded())
                .add("ActionsDefinition", hasActionsDefinition() ? actionsDefinition() : null)
                .add("TaskStatistics", taskStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "taskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "taskEndTime":
            return Optional.ofNullable(clazz.cast(taskEndTime()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "violationEventOccurrenceRange":
            return Optional.ofNullable(clazz.cast(violationEventOccurrenceRange()));
        case "onlyActiveViolationsIncluded":
            return Optional.ofNullable(clazz.cast(onlyActiveViolationsIncluded()));
        case "suppressedAlertsIncluded":
            return Optional.ofNullable(clazz.cast(suppressedAlertsIncluded()));
        case "actionsDefinition":
            return Optional.ofNullable(clazz.cast(actionsDefinition()));
        case "taskStatistics":
            return Optional.ofNullable(clazz.cast(taskStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionsTaskSummary, T> g) {
        return obj -> g.apply((DetectMitigationActionsTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectMitigationActionsTaskSummary> {
        /**
         * <p>
         * The unique identifier of the task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param taskStatus
         *        The status of the task.
         * @see DetectMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectMitigationActionsTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param taskStatus
         *        The status of the task.
         * @see DetectMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectMitigationActionsTaskStatus
         */
        Builder taskStatus(DetectMitigationActionsTaskStatus taskStatus);

        /**
         * <p>
         * The date the task started.
         * </p>
         * 
         * @param taskStartTime
         *        The date the task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * The date the task ended.
         * </p>
         * 
         * @param taskEndTime
         *        The date the task ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskEndTime(Instant taskEndTime);

        /**
         * <p>
         * Specifies the ML Detect findings to which the mitigation actions are applied.
         * </p>
         * 
         * @param target
         *        Specifies the ML Detect findings to which the mitigation actions are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(DetectMitigationActionsTaskTarget target);

        /**
         * <p>
         * Specifies the ML Detect findings to which the mitigation actions are applied.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectMitigationActionsTaskTarget.Builder}
         * avoiding the need to create one manually via {@link DetectMitigationActionsTaskTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectMitigationActionsTaskTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(DetectMitigationActionsTaskTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link DetectMitigationActionsTaskTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(DetectMitigationActionsTaskTarget)
         */
        default Builder target(Consumer<DetectMitigationActionsTaskTarget.Builder> target) {
            return target(DetectMitigationActionsTaskTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Specifies the time period of which violation events occurred between.
         * </p>
         * 
         * @param violationEventOccurrenceRange
         *        Specifies the time period of which violation events occurred between.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange);

        /**
         * <p>
         * Specifies the time period of which violation events occurred between.
         * </p>
         * This is a convenience that creates an instance of the {@link ViolationEventOccurrenceRange.Builder} avoiding
         * the need to create one manually via {@link ViolationEventOccurrenceRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ViolationEventOccurrenceRange.Builder#build()} is called
         * immediately and its result is passed to {@link #violationEventOccurrenceRange(ViolationEventOccurrenceRange)}
         * .
         * 
         * @param violationEventOccurrenceRange
         *        a consumer that will call methods on {@link ViolationEventOccurrenceRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEventOccurrenceRange(ViolationEventOccurrenceRange)
         */
        default Builder violationEventOccurrenceRange(
                Consumer<ViolationEventOccurrenceRange.Builder> violationEventOccurrenceRange) {
            return violationEventOccurrenceRange(ViolationEventOccurrenceRange.builder()
                    .applyMutation(violationEventOccurrenceRange).build());
        }

        /**
         * <p>
         * Includes only active violations.
         * </p>
         * 
         * @param onlyActiveViolationsIncluded
         *        Includes only active violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyActiveViolationsIncluded(Boolean onlyActiveViolationsIncluded);

        /**
         * <p>
         * Includes suppressed alerts.
         * </p>
         * 
         * @param suppressedAlertsIncluded
         *        Includes suppressed alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedAlertsIncluded(Boolean suppressedAlertsIncluded);

        /**
         * <p>
         * The definition of the actions.
         * </p>
         * 
         * @param actionsDefinition
         *        The definition of the actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsDefinition(Collection<MitigationAction> actionsDefinition);

        /**
         * <p>
         * The definition of the actions.
         * </p>
         * 
         * @param actionsDefinition
         *        The definition of the actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsDefinition(MitigationAction... actionsDefinition);

        /**
         * <p>
         * The definition of the actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MitigationAction>.Builder} avoiding the
         * need to create one manually via {@link List<MitigationAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MitigationAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #actionsDefinition(List<MitigationAction>)}.
         * 
         * @param actionsDefinition
         *        a consumer that will call methods on {@link List<MitigationAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsDefinition(List<MitigationAction>)
         */
        Builder actionsDefinition(Consumer<MitigationAction.Builder>... actionsDefinition);

        /**
         * <p>
         * The statistics of a mitigation action task.
         * </p>
         * 
         * @param taskStatistics
         *        The statistics of a mitigation action task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatistics(DetectMitigationActionsTaskStatistics taskStatistics);

        /**
         * <p>
         * The statistics of a mitigation action task.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectMitigationActionsTaskStatistics.Builder}
         * avoiding the need to create one manually via {@link DetectMitigationActionsTaskStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectMitigationActionsTaskStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #taskStatistics(DetectMitigationActionsTaskStatistics)}.
         * 
         * @param taskStatistics
         *        a consumer that will call methods on {@link DetectMitigationActionsTaskStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskStatistics(DetectMitigationActionsTaskStatistics)
         */
        default Builder taskStatistics(Consumer<DetectMitigationActionsTaskStatistics.Builder> taskStatistics) {
            return taskStatistics(DetectMitigationActionsTaskStatistics.builder().applyMutation(taskStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskStatus;

        private Instant taskStartTime;

        private Instant taskEndTime;

        private DetectMitigationActionsTaskTarget target;

        private ViolationEventOccurrenceRange violationEventOccurrenceRange;

        private Boolean onlyActiveViolationsIncluded;

        private Boolean suppressedAlertsIncluded;

        private List<MitigationAction> actionsDefinition = DefaultSdkAutoConstructList.getInstance();

        private DetectMitigationActionsTaskStatistics taskStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionsTaskSummary model) {
            taskId(model.taskId);
            taskStatus(model.taskStatus);
            taskStartTime(model.taskStartTime);
            taskEndTime(model.taskEndTime);
            target(model.target);
            violationEventOccurrenceRange(model.violationEventOccurrenceRange);
            onlyActiveViolationsIncluded(model.onlyActiveViolationsIncluded);
            suppressedAlertsIncluded(model.suppressedAlertsIncluded);
            actionsDefinition(model.actionsDefinition);
            taskStatistics(model.taskStatistics);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(DetectMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getTaskEndTime() {
            return taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        public final DetectMitigationActionsTaskTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(DetectMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(DetectMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final ViolationEventOccurrenceRange.Builder getViolationEventOccurrenceRange() {
            return violationEventOccurrenceRange != null ? violationEventOccurrenceRange.toBuilder() : null;
        }

        @Override
        public final Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange;
            return this;
        }

        public final void setViolationEventOccurrenceRange(ViolationEventOccurrenceRange.BuilderImpl violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange != null ? violationEventOccurrenceRange.build()
                    : null;
        }

        public final Boolean getOnlyActiveViolationsIncluded() {
            return onlyActiveViolationsIncluded;
        }

        @Override
        public final Builder onlyActiveViolationsIncluded(Boolean onlyActiveViolationsIncluded) {
            this.onlyActiveViolationsIncluded = onlyActiveViolationsIncluded;
            return this;
        }

        public final void setOnlyActiveViolationsIncluded(Boolean onlyActiveViolationsIncluded) {
            this.onlyActiveViolationsIncluded = onlyActiveViolationsIncluded;
        }

        public final Boolean getSuppressedAlertsIncluded() {
            return suppressedAlertsIncluded;
        }

        @Override
        public final Builder suppressedAlertsIncluded(Boolean suppressedAlertsIncluded) {
            this.suppressedAlertsIncluded = suppressedAlertsIncluded;
            return this;
        }

        public final void setSuppressedAlertsIncluded(Boolean suppressedAlertsIncluded) {
            this.suppressedAlertsIncluded = suppressedAlertsIncluded;
        }

        public final Collection<MitigationAction.Builder> getActionsDefinition() {
            if (actionsDefinition instanceof SdkAutoConstructList) {
                return null;
            }
            return actionsDefinition != null ? actionsDefinition.stream().map(MitigationAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionsDefinition(Collection<MitigationAction> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copy(actionsDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(MitigationAction... actionsDefinition) {
            actionsDefinition(Arrays.asList(actionsDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(Consumer<MitigationAction.Builder>... actionsDefinition) {
            actionsDefinition(Stream.of(actionsDefinition).map(c -> MitigationAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActionsDefinition(Collection<MitigationAction.BuilderImpl> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copyFromBuilder(actionsDefinition);
        }

        public final DetectMitigationActionsTaskStatistics.Builder getTaskStatistics() {
            return taskStatistics != null ? taskStatistics.toBuilder() : null;
        }

        @Override
        public final Builder taskStatistics(DetectMitigationActionsTaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return this;
        }

        public final void setTaskStatistics(DetectMitigationActionsTaskStatistics.BuilderImpl taskStatistics) {
            this.taskStatistics = taskStatistics != null ? taskStatistics.build() : null;
        }

        @Override
        public DetectMitigationActionsTaskSummary build() {
            return new DetectMitigationActionsTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
