/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to create a staged rollout of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionsRolloutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionsRolloutConfig.Builder, JobExecutionsRolloutConfig> {
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPerMinute").getter(getter(JobExecutionsRolloutConfig::maximumPerMinute))
            .setter(setter(Builder::maximumPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()).build();

    private static final SdkField<ExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField
            .<ExponentialRolloutRate> builder(MarshallingType.SDK_POJO).memberName("exponentialRate")
            .getter(getter(JobExecutionsRolloutConfig::exponentialRate)).setter(setter(Builder::exponentialRate))
            .constructor(ExponentialRolloutRate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_PER_MINUTE_FIELD,
            EXPONENTIAL_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumPerMinute;

    private final ExponentialRolloutRate exponentialRate;

    private JobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
        this.exponentialRate = builder.exponentialRate;
    }

    /**
     * <p>
     * The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to
     * create a staged rollout.
     * </p>
     * 
     * @return The maximum number of things that will be notified of a pending job, per minute. This parameter allows
     *         you to create a staged rollout.
     */
    public Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    /**
     * <p>
     * The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job
     * rollout.
     * </p>
     * 
     * @return The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job
     *         rollout.
     */
    public ExponentialRolloutRate exponentialRate() {
        return exponentialRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(exponentialRate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionsRolloutConfig)) {
            return false;
        }
        JobExecutionsRolloutConfig other = (JobExecutionsRolloutConfig) obj;
        return Objects.equals(maximumPerMinute(), other.maximumPerMinute())
                && Objects.equals(exponentialRate(), other.exponentialRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobExecutionsRolloutConfig").add("MaximumPerMinute", maximumPerMinute())
                .add("ExponentialRate", exponentialRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        case "exponentialRate":
            return Optional.ofNullable(clazz.cast(exponentialRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((JobExecutionsRolloutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionsRolloutConfig> {
        /**
         * <p>
         * The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to
         * create a staged rollout.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of things that will be notified of a pending job, per minute. This parameter allows
         *        you to create a staged rollout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);

        /**
         * <p>
         * The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job
         * rollout.
         * </p>
         * 
         * @param exponentialRate
         *        The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a
         *        job rollout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exponentialRate(ExponentialRolloutRate exponentialRate);

        /**
         * <p>
         * The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job
         * rollout.
         * </p>
         * This is a convenience that creates an instance of the {@link ExponentialRolloutRate.Builder} avoiding the
         * need to create one manually via {@link ExponentialRolloutRate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExponentialRolloutRate.Builder#build()} is called immediately and
         * its result is passed to {@link #exponentialRate(ExponentialRolloutRate)}.
         * 
         * @param exponentialRate
         *        a consumer that will call methods on {@link ExponentialRolloutRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exponentialRate(ExponentialRolloutRate)
         */
        default Builder exponentialRate(Consumer<ExponentialRolloutRate.Builder> exponentialRate) {
            return exponentialRate(ExponentialRolloutRate.builder().applyMutation(exponentialRate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumPerMinute;

        private ExponentialRolloutRate exponentialRate;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionsRolloutConfig model) {
            maximumPerMinute(model.maximumPerMinute);
            exponentialRate(model.exponentialRate);
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        public final ExponentialRolloutRate.Builder getExponentialRate() {
            return exponentialRate != null ? exponentialRate.toBuilder() : null;
        }

        @Override
        public final Builder exponentialRate(ExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        public final void setExponentialRate(ExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        @Override
        public JobExecutionsRolloutConfig build() {
            return new JobExecutionsRolloutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
