/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingRequest extends IotRequest implements
        ToCopyableBuilder<CreateThingRequest.Builder, CreateThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(CreateThingRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(CreateThingRequest::thingTypeName)).setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<AttributePayload> ATTRIBUTE_PAYLOAD_FIELD = SdkField
            .<AttributePayload> builder(MarshallingType.SDK_POJO).memberName("attributePayload")
            .getter(getter(CreateThingRequest::attributePayload)).setter(setter(Builder::attributePayload))
            .constructor(AttributePayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributePayload").build()).build();

    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupName").getter(getter(CreateThingRequest::billingGroupName))
            .setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_TYPE_NAME_FIELD, ATTRIBUTE_PAYLOAD_FIELD, BILLING_GROUP_NAME_FIELD));

    private final String thingName;

    private final String thingTypeName;

    private final AttributePayload attributePayload;

    private final String billingGroupName;

    private CreateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.billingGroupName = builder.billingGroupName;
    }

    /**
     * <p>
     * The name of the thing to create.
     * </p>
     * <p>
     * You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give
     * it the new name, and then delete the old thing.
     * </p>
     * 
     * @return The name of the thing to create.</p>
     *         <p>
     *         You can't change a thing's name after you create it. To change a thing's name, you must create a new
     *         thing, give it the new name, and then delete the old thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type associated with the new thing.
     * </p>
     * 
     * @return The name of the thing type associated with the new thing.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
     * </p>
     * <p>
     * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     * </p>
     * 
     * @return The attribute payload, which consists of up to three name/value pairs in a JSON document. For
     *         example:</p>
     *         <p>
     *         <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     */
    public AttributePayload attributePayload() {
        return attributePayload;
    }

    /**
     * <p>
     * The name of the billing group the thing will be added to.
     * </p>
     * 
     * @return The name of the billing group the thing will be added to.
     */
    public String billingGroupName() {
        return billingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributePayload());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingRequest)) {
            return false;
        }
        CreateThingRequest other = (CreateThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(attributePayload(), other.attributePayload())
                && Objects.equals(billingGroupName(), other.billingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateThingRequest").add("ThingName", thingName()).add("ThingTypeName", thingTypeName())
                .add("AttributePayload", attributePayload()).add("BillingGroupName", billingGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "attributePayload":
            return Optional.ofNullable(clazz.cast(attributePayload()));
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingRequest, T> g) {
        return obj -> g.apply((CreateThingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingRequest> {
        /**
         * <p>
         * The name of the thing to create.
         * </p>
         * <p>
         * You can't change a thing's name after you create it. To change a thing's name, you must create a new thing,
         * give it the new name, and then delete the old thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to create.</p>
         *        <p>
         *        You can't change a thing's name after you create it. To change a thing's name, you must create a new
         *        thing, give it the new name, and then delete the old thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type associated with the new thing.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type associated with the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * </p>
         * 
         * @param attributePayload
         *        The attribute payload, which consists of up to three name/value pairs in a JSON document. For
         *        example:</p>
         *        <p>
         *        <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePayload(AttributePayload attributePayload);

        /**
         * <p>
         * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * </p>
         * This is a convenience that creates an instance of the {@link AttributePayload.Builder} avoiding the need to
         * create one manually via {@link AttributePayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributePayload.Builder#build()} is called immediately and its
         * result is passed to {@link #attributePayload(AttributePayload)}.
         * 
         * @param attributePayload
         *        a consumer that will call methods on {@link AttributePayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributePayload(AttributePayload)
         */
        default Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return attributePayload(AttributePayload.builder().applyMutation(attributePayload).build());
        }

        /**
         * <p>
         * The name of the billing group the thing will be added to.
         * </p>
         * 
         * @param billingGroupName
         *        The name of the billing group the thing will be added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private AttributePayload attributePayload;

        private String billingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingRequest model) {
            super(model);
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            attributePayload(model.attributePayload);
            billingGroupName(model.billingGroupName);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return attributePayload != null ? attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingRequest build() {
            return new CreateThingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
