/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRule implements SdkPojo, Serializable, ToCopyableBuilder<TopicRule.Builder, TopicRule> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(TopicRule::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sql")
            .getter(getter(TopicRule::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TopicRule::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(TopicRule::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(TopicRule::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RULE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ruleDisabled").getter(getter(TopicRule::ruleDisabled)).setter(setter(Builder::ruleDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDisabled").build()).build();

    private static final SdkField<String> AWS_IOT_SQL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIotSqlVersion").getter(getter(TopicRule::awsIotSqlVersion)).setter(setter(Builder::awsIotSqlVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotSqlVersion").build()).build();

    private static final SdkField<Action> ERROR_ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO)
            .memberName("errorAction").getter(getter(TopicRule::errorAction)).setter(setter(Builder::errorAction))
            .constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, SQL_FIELD,
            DESCRIPTION_FIELD, CREATED_AT_FIELD, ACTIONS_FIELD, RULE_DISABLED_FIELD, AWS_IOT_SQL_VERSION_FIELD,
            ERROR_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String sql;

    private final String description;

    private final Instant createdAt;

    private final List<Action> actions;

    private final Boolean ruleDisabled;

    private final String awsIotSqlVersion;

    private final Action errorAction;

    private TopicRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.sql = builder.sql;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
        this.errorAction = builder.errorAction;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the
     * newline characters.
     * </p>
     * 
     * @return The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape
     *         the newline characters.
     */
    public String sql() {
        return sql;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the rule was created.
     * </p>
     * 
     * @return The date and time the rule was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions associated with the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions associated with the rule.
     */
    public List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public Boolean ruleDisabled() {
        return ruleDisabled;
    }

    /**
     * <p>
     * The version of the SQL rules engine to use when evaluating the rule.
     * </p>
     * 
     * @return The version of the SQL rules engine to use when evaluating the rule.
     */
    public String awsIotSqlVersion() {
        return awsIotSqlVersion;
    }

    /**
     * <p>
     * The action to perform when an error occurs.
     * </p>
     * 
     * @return The action to perform when an error occurs.
     */
    public Action errorAction() {
        return errorAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotSqlVersion());
        hashCode = 31 * hashCode + Objects.hashCode(errorAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRule)) {
            return false;
        }
        TopicRule other = (TopicRule) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(sql(), other.sql())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(actions(), other.actions()) && Objects.equals(ruleDisabled(), other.ruleDisabled())
                && Objects.equals(awsIotSqlVersion(), other.awsIotSqlVersion())
                && Objects.equals(errorAction(), other.errorAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TopicRule").add("RuleName", ruleName()).add("Sql", sql()).add("Description", description())
                .add("CreatedAt", createdAt()).add("Actions", actions()).add("RuleDisabled", ruleDisabled())
                .add("AwsIotSqlVersion", awsIotSqlVersion()).add("ErrorAction", errorAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "ruleDisabled":
            return Optional.ofNullable(clazz.cast(ruleDisabled()));
        case "awsIotSqlVersion":
            return Optional.ofNullable(clazz.cast(awsIotSqlVersion()));
        case "errorAction":
            return Optional.ofNullable(clazz.cast(errorAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRule, T> g) {
        return obj -> g.apply((TopicRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRule> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the
         * newline characters.
         * </p>
         * 
         * @param sql
         *        The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to
         *        escape the newline characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the rule was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);

        /**
         * <p>
         * The version of the SQL rules engine to use when evaluating the rule.
         * </p>
         * 
         * @param awsIotSqlVersion
         *        The version of the SQL rules engine to use when evaluating the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotSqlVersion(String awsIotSqlVersion);

        /**
         * <p>
         * The action to perform when an error occurs.
         * </p>
         * 
         * @param errorAction
         *        The action to perform when an error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorAction(Action errorAction);

        /**
         * <p>
         * The action to perform when an error occurs.
         * </p>
         * This is a convenience that creates an instance of the {@link Action.Builder} avoiding the need to create one
         * manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #errorAction(Action)}.
         * 
         * @param errorAction
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorAction(Action)
         */
        default Builder errorAction(Consumer<Action.Builder> errorAction) {
            return errorAction(Action.builder().applyMutation(errorAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String sql;

        private String description;

        private Instant createdAt;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Boolean ruleDisabled;

        private String awsIotSqlVersion;

        private Action errorAction;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRule model) {
            ruleName(model.ruleName);
            sql(model.sql);
            description(model.description);
            createdAt(model.createdAt);
            actions(model.actions);
            ruleDisabled(model.ruleDisabled);
            awsIotSqlVersion(model.awsIotSqlVersion);
            errorAction(model.errorAction);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getSql() {
            return sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<Action.Builder> getActions() {
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public final String getAwsIotSqlVersion() {
            return awsIotSqlVersion;
        }

        @Override
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        public final Action.Builder getErrorAction() {
            return errorAction != null ? errorAction.toBuilder() : null;
        }

        @Override
        public final Builder errorAction(Action errorAction) {
            this.errorAction = errorAction;
            return this;
        }

        public final void setErrorAction(Action.BuilderImpl errorAction) {
            this.errorAction = errorAction != null ? errorAction.build() : null;
        }

        @Override
        public TopicRule build() {
            return new TopicRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
