/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.AuditSuppression;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse;

public class ListAuditSuppressionsPublisher
implements SdkPublisher<ListAuditSuppressionsResponse> {
    private final IotAsyncClient client;
    private final ListAuditSuppressionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuditSuppressionsPublisher(IotAsyncClient client, ListAuditSuppressionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuditSuppressionsPublisher(IotAsyncClient client, ListAuditSuppressionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuditSuppressionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuditSuppressionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuditSuppression> suppressions() {
        Function<ListAuditSuppressionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.suppressions() != null) {
                return response.suppressions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuditSuppressionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuditSuppressionsResponseFetcher
    implements AsyncPageFetcher<ListAuditSuppressionsResponse> {
        private ListAuditSuppressionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditSuppressionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuditSuppressionsResponse> nextPage(ListAuditSuppressionsResponse previousPage) {
            if (previousPage == null) {
                return ListAuditSuppressionsPublisher.this.client.listAuditSuppressions(ListAuditSuppressionsPublisher.this.firstRequest);
            }
            return ListAuditSuppressionsPublisher.this.client.listAuditSuppressions((ListAuditSuppressionsRequest)((Object)ListAuditSuppressionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

