/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoleAliasRequest extends IotRequest implements
        ToCopyableBuilder<CreateRoleAliasRequest.Builder, CreateRoleAliasRequest> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleAlias").getter(getter(CreateRoleAliasRequest::roleAlias)).setter(setter(Builder::roleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("roleAlias").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateRoleAliasRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Integer> CREDENTIAL_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("credentialDurationSeconds")
            .getter(getter(CreateRoleAliasRequest::credentialDurationSeconds)).setter(setter(Builder::credentialDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialDurationSeconds").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRoleAliasRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD,
            ROLE_ARN_FIELD, CREDENTIAL_DURATION_SECONDS_FIELD, TAGS_FIELD));

    private final String roleAlias;

    private final String roleArn;

    private final Integer credentialDurationSeconds;

    private final List<Tag> tags;

    private CreateRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleArn = builder.roleArn;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The role alias that points to a role ARN. This allows you to change the role without having to update the device.
     * </p>
     * 
     * @return The role alias that points to a role ARN. This allows you to change the role without having to update the
     *         device.
     */
    public final String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * How long (in seconds) the credentials will be valid.
     * </p>
     * 
     * @return How long (in seconds) the credentials will be valid.
     */
    public final Integer credentialDurationSeconds() {
        return credentialDurationSeconds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the role alias.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata which can be used to manage the role alias.</p> <note>
     *         <p>
     *         For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *         </p>
     *         <p>
     *         For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *         </p>
     *         <p>
     *         For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleAliasRequest)) {
            return false;
        }
        CreateRoleAliasRequest other = (CreateRoleAliasRequest) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(credentialDurationSeconds(), other.credentialDurationSeconds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoleAliasRequest").add("RoleAlias", roleAlias()).add("RoleArn", roleArn())
                .add("CredentialDurationSeconds", credentialDurationSeconds()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "credentialDurationSeconds":
            return Optional.ofNullable(clazz.cast(credentialDurationSeconds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleAliasRequest, T> g) {
        return obj -> g.apply((CreateRoleAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoleAliasRequest> {
        /**
         * <p>
         * The role alias that points to a role ARN. This allows you to change the role without having to update the
         * device.
         * </p>
         * 
         * @param roleAlias
         *        The role alias that points to a role ARN. This allows you to change the role without having to update
         *        the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleArn
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * How long (in seconds) the credentials will be valid.
         * </p>
         * 
         * @param credentialDurationSeconds
         *        How long (in seconds) the credentials will be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialDurationSeconds(Integer credentialDurationSeconds);

        /**
         * <p>
         * Metadata which can be used to manage the role alias.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the role alias.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the role alias.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the role alias.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the role alias.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String roleAlias;

        private String roleArn;

        private Integer credentialDurationSeconds;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleAliasRequest model) {
            super(model);
            roleAlias(model.roleAlias);
            roleArn(model.roleArn);
            credentialDurationSeconds(model.credentialDurationSeconds);
            tags(model.tags);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getCredentialDurationSeconds() {
            return credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleAliasRequest build() {
            return new CreateRoleAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
