/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<CreateThingGroupResponse.Builder, CreateThingGroupResponse> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupName").getter(getter(CreateThingGroupResponse::thingGroupName))
            .setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()).build();

    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupArn").getter(getter(CreateThingGroupResponse::thingGroupArn))
            .setter(setter(Builder::thingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()).build();

    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupId").getter(getter(CreateThingGroupResponse::thingGroupId))
            .setter(setter(Builder::thingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_ARN_FIELD, THING_GROUP_ID_FIELD));

    private final String thingGroupName;

    private final String thingGroupArn;

    private final String thingGroupId;

    private CreateThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupArn = builder.thingGroupArn;
        this.thingGroupId = builder.thingGroupId;
    }

    /**
     * <p>
     * The thing group name.
     * </p>
     * 
     * @return The thing group name.
     */
    public final String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group ARN.
     * </p>
     * 
     * @return The thing group ARN.
     */
    public final String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The thing group ID.
     * </p>
     * 
     * @return The thing group ID.
     */
    public final String thingGroupId() {
        return thingGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingGroupResponse)) {
            return false;
        }
        CreateThingGroupResponse other = (CreateThingGroupResponse) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupArn(), other.thingGroupArn())
                && Objects.equals(thingGroupId(), other.thingGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThingGroupResponse").add("ThingGroupName", thingGroupName())
                .add("ThingGroupArn", thingGroupArn()).add("ThingGroupId", thingGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingGroupResponse, T> g) {
        return obj -> g.apply((CreateThingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingGroupResponse> {
        /**
         * <p>
         * The thing group name.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group ARN.
         * </p>
         * 
         * @param thingGroupArn
         *        The thing group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupArn;

        private String thingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingGroupResponse model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupArn(model.thingGroupArn);
            thingGroupId(model.thingGroupId);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        @Override
        public CreateThingGroupResponse build() {
            return new CreateThingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
