/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTopicRuleDestinationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateTopicRuleDestinationRequest.Builder, UpdateTopicRuleDestinationRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateTopicRuleDestinationRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateTopicRuleDestinationRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD));

    private final String arn;

    private final String status;

    private UpdateTopicRuleDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the topic rule destination.
     * </p>
     * 
     * @return The ARN of the topic rule destination.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public final TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTopicRuleDestinationRequest)) {
            return false;
        }
        UpdateTopicRuleDestinationRequest other = (UpdateTopicRuleDestinationRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTopicRuleDestinationRequest").add("Arn", arn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTopicRuleDestinationRequest, T> g) {
        return obj -> g.apply((UpdateTopicRuleDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTopicRuleDestinationRequest> {
        /**
         * <p>
         * The ARN of the topic rule destination.
         * </p>
         * 
         * @param arn
         *        The ARN of the topic rule destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(TopicRuleDestinationStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String arn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTopicRuleDestinationRequest model) {
            super(model);
            arn(model.arn);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTopicRuleDestinationRequest build() {
            return new UpdateTopicRuleDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
