/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.RoleAliasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoleAliasesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListRoleAliasesResponse> {
    private static final SdkField<List<String>> ROLE_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roleAliases").getter(ListRoleAliasesResponse.getter(ListRoleAliasesResponse::roleAliases)).setter(ListRoleAliasesResponse.setter(Builder::roleAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMarker").getter(ListRoleAliasesResponse.getter(ListRoleAliasesResponse::nextMarker)).setter(ListRoleAliasesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIASES_FIELD, NEXT_MARKER_FIELD));
    private final List<String> roleAliases;
    private final String nextMarker;

    private ListRoleAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.roleAliases = builder.roleAliases;
        this.nextMarker = builder.nextMarker;
    }

    public boolean hasRoleAliases() {
        return this.roleAliases != null && !(this.roleAliases instanceof SdkAutoConstructList);
    }

    public List<String> roleAliases() {
        return this.roleAliases;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoleAliasesResponse)) {
            return false;
        }
        ListRoleAliasesResponse other = (ListRoleAliasesResponse)((Object)obj);
        return Objects.equals(this.roleAliases(), other.roleAliases()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListRoleAliasesResponse").add("RoleAliases", this.roleAliases()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleAliases": {
                return Optional.ofNullable(clazz.cast(this.roleAliases()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoleAliasesResponse, T> g) {
        return obj -> g.apply((ListRoleAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> roleAliases = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoleAliasesResponse model) {
            super(model);
            this.roleAliases(model.roleAliases);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<String> getRoleAliases() {
            return this.roleAliases;
        }

        @Override
        public final Builder roleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleAliases(String ... roleAliases) {
            this.roleAliases(Arrays.asList(roleAliases));
            return this;
        }

        public final void setRoleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListRoleAliasesResponse build() {
            return new ListRoleAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoleAliasesResponse> {
        public Builder roleAliases(Collection<String> var1);

        public Builder roleAliases(String ... var1);

        public Builder nextMarker(String var1);
    }
}

