/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEffectivePoliciesRequest
extends IotRequest
implements ToCopyableBuilder<Builder, GetEffectivePoliciesRequest> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(GetEffectivePoliciesRequest.getter(GetEffectivePoliciesRequest::principal)).setter(GetEffectivePoliciesRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cognitoIdentityPoolId").getter(GetEffectivePoliciesRequest.getter(GetEffectivePoliciesRequest::cognitoIdentityPoolId)).setter(GetEffectivePoliciesRequest.setter(Builder::cognitoIdentityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(GetEffectivePoliciesRequest.getter(GetEffectivePoliciesRequest::thingName)).setter(GetEffectivePoliciesRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, COGNITO_IDENTITY_POOL_ID_FIELD, THING_NAME_FIELD));
    private final String principal;
    private final String cognitoIdentityPoolId;
    private final String thingName;

    private GetEffectivePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.thingName = builder.thingName;
    }

    public final String principal() {
        return this.principal;
    }

    public final String cognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public final String thingName() {
        return this.thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePoliciesRequest)) {
            return false;
        }
        GetEffectivePoliciesRequest other = (GetEffectivePoliciesRequest)((Object)obj);
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.cognitoIdentityPoolId(), other.cognitoIdentityPoolId()) && Objects.equals(this.thingName(), other.thingName());
    }

    public final String toString() {
        return ToString.builder((String)"GetEffectivePoliciesRequest").add("Principal", (Object)this.principal()).add("CognitoIdentityPoolId", (Object)this.cognitoIdentityPoolId()).add("ThingName", (Object)this.thingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "cognitoIdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityPoolId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectivePoliciesRequest, T> g) {
        return obj -> g.apply((GetEffectivePoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String principal;
        private String cognitoIdentityPoolId;
        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePoliciesRequest model) {
            super(model);
            this.principal(model.principal);
            this.cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            this.thingName(model.thingName);
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEffectivePoliciesRequest build() {
            return new GetEffectivePoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEffectivePoliciesRequest> {
        public Builder principal(String var1);

        public Builder cognitoIdentityPoolId(String var1);

        public Builder thingName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

