/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connectivity status of the thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingConnectivity implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingConnectivity.Builder, ThingConnectivity> {
    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("connected").getter(getter(ThingConnectivity::connected)).setter(setter(Builder::connected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connected").build()).build();

    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timestamp")
            .getter(getter(ThingConnectivity::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_FIELD,
            TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean connected;

    private final Long timestamp;

    private ThingConnectivity(BuilderImpl builder) {
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * True if the thing is connected to the AWS IoT service; false if it is not connected.
     * </p>
     * 
     * @return True if the thing is connected to the AWS IoT service; false if it is not connected.
     */
    public Boolean connected() {
        return connected;
    }

    /**
     * <p>
     * The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
     * disconnected for more than a few weeks, the time value might be missing.
     * </p>
     * 
     * @return The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
     *         disconnected for more than a few weeks, the time value might be missing.
     */
    public Long timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connected());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingConnectivity)) {
            return false;
        }
        ThingConnectivity other = (ThingConnectivity) obj;
        return Objects.equals(connected(), other.connected()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingConnectivity").add("Connected", connected()).add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connected":
            return Optional.ofNullable(clazz.cast(connected()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingConnectivity, T> g) {
        return obj -> g.apply((ThingConnectivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingConnectivity> {
        /**
         * <p>
         * True if the thing is connected to the AWS IoT service; false if it is not connected.
         * </p>
         * 
         * @param connected
         *        True if the thing is connected to the AWS IoT service; false if it is not connected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connected(Boolean connected);

        /**
         * <p>
         * The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
         * disconnected for more than a few weeks, the time value might be missing.
         * </p>
         * 
         * @param timestamp
         *        The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
         *        disconnected for more than a few weeks, the time value might be missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);
    }

    static final class BuilderImpl implements Builder {
        private Boolean connected;

        private Long timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingConnectivity model) {
            connected(model.connected);
            timestamp(model.timestamp);
        }

        public final Boolean getConnected() {
            return connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ThingConnectivity build() {
            return new ThingConnectivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
