/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ViolationEvent;
import software.amazon.awssdk.services.iot.model.ViolationEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListViolationEventsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListViolationEventsResponse> {
    private static final SdkField<List<ViolationEvent>> VIOLATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("violationEvents").getter(ListViolationEventsResponse.getter(ListViolationEventsResponse::violationEvents)).setter(ListViolationEventsResponse.setter(Builder::violationEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViolationEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListViolationEventsResponse.getter(ListViolationEventsResponse::nextToken)).setter(ListViolationEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ViolationEvent> violationEvents;
    private final String nextToken;

    private ListViolationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.violationEvents = builder.violationEvents;
        this.nextToken = builder.nextToken;
    }

    public boolean hasViolationEvents() {
        return this.violationEvents != null && !(this.violationEvents instanceof SdkAutoConstructList);
    }

    public List<ViolationEvent> violationEvents() {
        return this.violationEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViolationEventsResponse)) {
            return false;
        }
        ListViolationEventsResponse other = (ListViolationEventsResponse)((Object)obj);
        return Objects.equals(this.violationEvents(), other.violationEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListViolationEventsResponse").add("ViolationEvents", this.violationEvents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "violationEvents": {
                return Optional.ofNullable(clazz.cast(this.violationEvents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListViolationEventsResponse, T> g) {
        return obj -> g.apply((ListViolationEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ViolationEvent> violationEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListViolationEventsResponse model) {
            super(model);
            this.violationEvents(model.violationEvents);
            this.nextToken(model.nextToken);
        }

        public final Collection<ViolationEvent.Builder> getViolationEvents() {
            return this.violationEvents != null ? (Collection)this.violationEvents.stream().map(ViolationEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder violationEvents(Collection<ViolationEvent> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copy(violationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(ViolationEvent ... violationEvents) {
            this.violationEvents(Arrays.asList(violationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(Consumer<ViolationEvent.Builder> ... violationEvents) {
            this.violationEvents(Stream.of(violationEvents).map(c -> (ViolationEvent)((ViolationEvent.Builder)ViolationEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setViolationEvents(Collection<ViolationEvent.BuilderImpl> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copyFromBuilder(violationEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListViolationEventsResponse build() {
            return new ListViolationEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListViolationEventsResponse> {
        public Builder violationEvents(Collection<ViolationEvent> var1);

        public Builder violationEvents(ViolationEvent ... var1);

        public Builder violationEvents(Consumer<ViolationEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

