/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityProfileResponse extends IotResponse implements
        ToCopyableBuilder<CreateSecurityProfileResponse.Builder, CreateSecurityProfileResponse> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(CreateSecurityProfileResponse::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> SECURITY_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileArn").getter(getter(CreateSecurityProfileResponse::securityProfileArn))
            .setter(setter(Builder::securityProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_ARN_FIELD));

    private final String securityProfileName;

    private final String securityProfileArn;

    private CreateSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileArn = builder.securityProfileArn;
    }

    /**
     * <p>
     * The name you gave to the security profile.
     * </p>
     * 
     * @return The name you gave to the security profile.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The ARN of the security profile.
     * </p>
     * 
     * @return The ARN of the security profile.
     */
    public String securityProfileArn() {
        return securityProfileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileResponse)) {
            return false;
        }
        CreateSecurityProfileResponse other = (CreateSecurityProfileResponse) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileArn(), other.securityProfileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSecurityProfileResponse").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileArn", securityProfileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileArn":
            return Optional.ofNullable(clazz.cast(securityProfileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileResponse, T> g) {
        return obj -> g.apply((CreateSecurityProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecurityProfileResponse> {
        /**
         * <p>
         * The name you gave to the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name you gave to the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The ARN of the security profile.
         * </p>
         * 
         * @param securityProfileArn
         *        The ARN of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileArn(String securityProfileArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileResponse model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileArn(model.securityProfileArn);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileArn() {
            return securityProfileArn;
        }

        @Override
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        @Override
        public CreateSecurityProfileResponse build() {
            return new CreateSecurityProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
