/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingTypeResponse extends IotResponse implements
        ToCopyableBuilder<CreateThingTypeResponse.Builder, CreateThingTypeResponse> {
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(CreateThingTypeResponse::thingTypeName))
            .setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<String> THING_TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeArn").getter(getter(CreateThingTypeResponse::thingTypeArn))
            .setter(setter(Builder::thingTypeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeArn").build()).build();

    private static final SdkField<String> THING_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeId").getter(getter(CreateThingTypeResponse::thingTypeId)).setter(setter(Builder::thingTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_NAME_FIELD,
            THING_TYPE_ARN_FIELD, THING_TYPE_ID_FIELD));

    private final String thingTypeName;

    private final String thingTypeArn;

    private final String thingTypeId;

    private CreateThingTypeResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeArn = builder.thingTypeArn;
        this.thingTypeId = builder.thingTypeId;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the thing type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the thing type.
     */
    public String thingTypeArn() {
        return thingTypeArn;
    }

    /**
     * <p>
     * The thing type ID.
     * </p>
     * 
     * @return The thing type ID.
     */
    public String thingTypeId() {
        return thingTypeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeResponse)) {
            return false;
        }
        CreateThingTypeResponse other = (CreateThingTypeResponse) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName()) && Objects.equals(thingTypeArn(), other.thingTypeArn())
                && Objects.equals(thingTypeId(), other.thingTypeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateThingTypeResponse").add("ThingTypeName", thingTypeName())
                .add("ThingTypeArn", thingTypeArn()).add("ThingTypeId", thingTypeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingTypeArn":
            return Optional.ofNullable(clazz.cast(thingTypeArn()));
        case "thingTypeId":
            return Optional.ofNullable(clazz.cast(thingTypeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingTypeResponse, T> g) {
        return obj -> g.apply((CreateThingTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingTypeResponse> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the thing type.
         * </p>
         * 
         * @param thingTypeArn
         *        The Amazon Resource Name (ARN) of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeArn(String thingTypeArn);

        /**
         * <p>
         * The thing type ID.
         * </p>
         * 
         * @param thingTypeId
         *        The thing type ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeId(String thingTypeId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingTypeName;

        private String thingTypeArn;

        private String thingTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeResponse model) {
            super(model);
            thingTypeName(model.thingTypeName);
            thingTypeArn(model.thingTypeArn);
            thingTypeId(model.thingTypeId);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final String getThingTypeArn() {
            return thingTypeArn;
        }

        @Override
        public final Builder thingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
            return this;
        }

        public final void setThingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
        }

        public final String getThingTypeId() {
            return thingTypeId;
        }

        @Override
        public final Builder thingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
            return this;
        }

        public final void setThingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
        }

        @Override
        public CreateThingTypeResponse build() {
            return new CreateThingTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
