/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingGroupRequest extends IotRequest implements
        ToCopyableBuilder<CreateThingGroupRequest.Builder, CreateThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupName").getter(getter(CreateThingGroupRequest::thingGroupName))
            .setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingGroupName").build()).build();

    private static final SdkField<String> PARENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentGroupName").getter(getter(CreateThingGroupRequest::parentGroupName))
            .setter(setter(Builder::parentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentGroupName").build()).build();

    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField
            .<ThingGroupProperties> builder(MarshallingType.SDK_POJO).memberName("thingGroupProperties")
            .getter(getter(CreateThingGroupRequest::thingGroupProperties)).setter(setter(Builder::thingGroupProperties))
            .constructor(ThingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateThingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            PARENT_GROUP_NAME_FIELD, THING_GROUP_PROPERTIES_FIELD, TAGS_FIELD));

    private final String thingGroupName;

    private final String parentGroupName;

    private final ThingGroupProperties thingGroupProperties;

    private final List<Tag> tags;

    private CreateThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.parentGroupName = builder.parentGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The thing group name to create.
     * </p>
     * 
     * @return The thing group name to create.
     */
    public final String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The name of the parent thing group.
     * </p>
     * 
     * @return The name of the parent thing group.
     */
    public final String parentGroupName() {
        return parentGroupName;
    }

    /**
     * <p>
     * The thing group properties.
     * </p>
     * 
     * @return The thing group properties.
     */
    public final ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the thing group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata which can be used to manage the thing group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingGroupRequest)) {
            return false;
        }
        CreateThingGroupRequest other = (CreateThingGroupRequest) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName())
                && Objects.equals(parentGroupName(), other.parentGroupName())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThingGroupRequest").add("ThingGroupName", thingGroupName())
                .add("ParentGroupName", parentGroupName()).add("ThingGroupProperties", thingGroupProperties())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "parentGroupName":
            return Optional.ofNullable(clazz.cast(parentGroupName()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingGroupRequest, T> g) {
        return obj -> g.apply((CreateThingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingGroupRequest> {
        /**
         * <p>
         * The thing group name to create.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group name to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The name of the parent thing group.
         * </p>
         * 
         * @param parentGroupName
         *        The name of the parent thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupName(String parentGroupName);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * 
         * @param thingGroupProperties
         *        The thing group properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupProperties.Builder} avoiding the need
         * to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the thing group.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the thing group.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the thing group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingGroupName;

        private String parentGroupName;

        private ThingGroupProperties thingGroupProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingGroupRequest model) {
            super(model);
            thingGroupName(model.thingGroupName);
            parentGroupName(model.parentGroupName);
            thingGroupProperties(model.thingGroupProperties);
            tags(model.tags);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getParentGroupName() {
            return parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingGroupRequest build() {
            return new CreateThingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
