/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTopicRuleDestinationsResponse extends IotResponse implements
        ToCopyableBuilder<ListTopicRuleDestinationsResponse.Builder, ListTopicRuleDestinationsResponse> {
    private static final SdkField<List<TopicRuleDestinationSummary>> DESTINATION_SUMMARIES_FIELD = SdkField
            .<List<TopicRuleDestinationSummary>> builder(MarshallingType.LIST)
            .memberName("destinationSummaries")
            .getter(getter(ListTopicRuleDestinationsResponse::destinationSummaries))
            .setter(setter(Builder::destinationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicRuleDestinationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicRuleDestinationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTopicRuleDestinationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TopicRuleDestinationSummary> destinationSummaries;

    private final String nextToken;

    private ListTopicRuleDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.destinationSummaries = builder.destinationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DestinationSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationSummaries() {
        return destinationSummaries != null && !(destinationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a topic rule destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about a topic rule destination.
     */
    public final List<TopicRuleDestinationSummary> destinationSummaries() {
        return destinationSummaries;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationSummaries() ? destinationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRuleDestinationsResponse)) {
            return false;
        }
        ListTopicRuleDestinationsResponse other = (ListTopicRuleDestinationsResponse) obj;
        return hasDestinationSummaries() == other.hasDestinationSummaries()
                && Objects.equals(destinationSummaries(), other.destinationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTopicRuleDestinationsResponse")
                .add("DestinationSummaries", hasDestinationSummaries() ? destinationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationSummaries":
            return Optional.ofNullable(clazz.cast(destinationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTopicRuleDestinationsResponse, T> g) {
        return obj -> g.apply((ListTopicRuleDestinationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTopicRuleDestinationsResponse> {
        /**
         * <p>
         * Information about a topic rule destination.
         * </p>
         * 
         * @param destinationSummaries
         *        Information about a topic rule destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSummaries(Collection<TopicRuleDestinationSummary> destinationSummaries);

        /**
         * <p>
         * Information about a topic rule destination.
         * </p>
         * 
         * @param destinationSummaries
         *        Information about a topic rule destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSummaries(TopicRuleDestinationSummary... destinationSummaries);

        /**
         * <p>
         * Information about a topic rule destination.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TopicRuleDestinationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TopicRuleDestinationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TopicRuleDestinationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationSummaries(List<TopicRuleDestinationSummary>)}.
         * 
         * @param destinationSummaries
         *        a consumer that will call methods on {@link List<TopicRuleDestinationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSummaries(List<TopicRuleDestinationSummary>)
         */
        Builder destinationSummaries(Consumer<TopicRuleDestinationSummary.Builder>... destinationSummaries);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<TopicRuleDestinationSummary> destinationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRuleDestinationsResponse model) {
            super(model);
            destinationSummaries(model.destinationSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<TopicRuleDestinationSummary.Builder> getDestinationSummaries() {
            if (destinationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationSummaries != null ? destinationSummaries.stream().map(TopicRuleDestinationSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationSummaries(Collection<TopicRuleDestinationSummary> destinationSummaries) {
            this.destinationSummaries = TopicRuleDestinationSummariesCopier.copy(destinationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationSummaries(TopicRuleDestinationSummary... destinationSummaries) {
            destinationSummaries(Arrays.asList(destinationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationSummaries(Consumer<TopicRuleDestinationSummary.Builder>... destinationSummaries) {
            destinationSummaries(Stream.of(destinationSummaries)
                    .map(c -> TopicRuleDestinationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationSummaries(Collection<TopicRuleDestinationSummary.BuilderImpl> destinationSummaries) {
            this.destinationSummaries = TopicRuleDestinationSummariesCopier.copyFromBuilder(destinationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicRuleDestinationsResponse build() {
            return new ListTopicRuleDestinationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
