/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuditMitigationActionsTaskResponse extends IotResponse implements
        ToCopyableBuilder<DescribeAuditMitigationActionsTaskResponse.Builder, DescribeAuditMitigationActionsTaskResponse> {
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(DescribeAuditMitigationActionsTaskResponse::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DescribeAuditMitigationActionsTaskResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DescribeAuditMitigationActionsTaskResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Map<String, TaskStatisticsForAuditCheck>> TASK_STATISTICS_FIELD = SdkField
            .<Map<String, TaskStatisticsForAuditCheck>> builder(MarshallingType.MAP)
            .memberName("taskStatistics")
            .getter(getter(DescribeAuditMitigationActionsTaskResponse::taskStatistics))
            .setter(setter(Builder::taskStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatistics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TaskStatisticsForAuditCheck> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskStatisticsForAuditCheck::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuditMitigationActionsTaskTarget> TARGET_FIELD = SdkField
            .<AuditMitigationActionsTaskTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(DescribeAuditMitigationActionsTaskResponse::target)).setter(setter(Builder::target))
            .constructor(AuditMitigationActionsTaskTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("auditCheckToActionsMapping")
            .getter(getter(DescribeAuditMitigationActionsTaskResponse::auditCheckToActionsMapping))
            .setter(setter(Builder::auditCheckToActionsMapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToActionsMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<MitigationAction>> ACTIONS_DEFINITION_FIELD = SdkField
            .<List<MitigationAction>> builder(MarshallingType.LIST)
            .memberName("actionsDefinition")
            .getter(getter(DescribeAuditMitigationActionsTaskResponse::actionsDefinition))
            .setter(setter(Builder::actionsDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsDefinition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MitigationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(MitigationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_STATUS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, TASK_STATISTICS_FIELD, TARGET_FIELD, AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD,
            ACTIONS_DEFINITION_FIELD));

    private final String taskStatus;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, TaskStatisticsForAuditCheck> taskStatistics;

    private final AuditMitigationActionsTaskTarget target;

    private final Map<String, List<String>> auditCheckToActionsMapping;

    private final List<MitigationAction> actionsDefinition;

    private DescribeAuditMitigationActionsTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskStatus = builder.taskStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.taskStatistics = builder.taskStatistics;
        this.target = builder.target;
        this.auditCheckToActionsMapping = builder.auditCheckToActionsMapping;
        this.actionsDefinition = builder.actionsDefinition;
    }

    /**
     * <p>
     * The current status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The current status of the task.
     * @see AuditMitigationActionsTaskStatus
     */
    public final AuditMitigationActionsTaskStatus taskStatus() {
        return AuditMitigationActionsTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The current status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The current status of the task.
     * @see AuditMitigationActionsTaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The date and time when the task was started.
     * </p>
     * 
     * @return The date and time when the task was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the task was completed or canceled.
     * </p>
     * 
     * @return The date and time when the task was completed or canceled.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns true if the TaskStatistics property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTaskStatistics() {
        return taskStatistics != null && !(taskStatistics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation
     * actions task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTaskStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit
     *         mitigation actions task.
     */
    public final Map<String, TaskStatisticsForAuditCheck> taskStatistics() {
        return taskStatistics;
    }

    /**
     * <p>
     * Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task,
     * or a set of findings.
     * </p>
     * 
     * @return Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by
     *         audit task, or a set of findings.
     */
    public final AuditMitigationActionsTaskTarget target() {
        return target;
    }

    /**
     * Returns true if the AuditCheckToActionsMapping property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAuditCheckToActionsMapping() {
        return auditCheckToActionsMapping != null && !(auditCheckToActionsMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the mitigation actions that should be applied to specific audit checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuditCheckToActionsMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the mitigation actions that should be applied to specific audit checks.
     */
    public final Map<String, List<String>> auditCheckToActionsMapping() {
        return auditCheckToActionsMapping;
    }

    /**
     * Returns true if the ActionsDefinition property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasActionsDefinition() {
        return actionsDefinition != null && !(actionsDefinition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the mitigation actions and their parameters that are applied as part of this task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionsDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the mitigation actions and their parameters that are applied as part of this task.
     */
    public final List<MitigationAction> actionsDefinition() {
        return actionsDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskStatistics() ? taskStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditCheckToActionsMapping() ? auditCheckToActionsMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsDefinition() ? actionsDefinition() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditMitigationActionsTaskResponse)) {
            return false;
        }
        DescribeAuditMitigationActionsTaskResponse other = (DescribeAuditMitigationActionsTaskResponse) obj;
        return Objects.equals(taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasTaskStatistics() == other.hasTaskStatistics()
                && Objects.equals(taskStatistics(), other.taskStatistics()) && Objects.equals(target(), other.target())
                && hasAuditCheckToActionsMapping() == other.hasAuditCheckToActionsMapping()
                && Objects.equals(auditCheckToActionsMapping(), other.auditCheckToActionsMapping())
                && hasActionsDefinition() == other.hasActionsDefinition()
                && Objects.equals(actionsDefinition(), other.actionsDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAuditMitigationActionsTaskResponse").add("TaskStatus", taskStatusAsString())
                .add("StartTime", startTime()).add("EndTime", endTime())
                .add("TaskStatistics", hasTaskStatistics() ? taskStatistics() : null).add("Target", target())
                .add("AuditCheckToActionsMapping", hasAuditCheckToActionsMapping() ? auditCheckToActionsMapping() : null)
                .add("ActionsDefinition", hasActionsDefinition() ? actionsDefinition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "taskStatistics":
            return Optional.ofNullable(clazz.cast(taskStatistics()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "auditCheckToActionsMapping":
            return Optional.ofNullable(clazz.cast(auditCheckToActionsMapping()));
        case "actionsDefinition":
            return Optional.ofNullable(clazz.cast(actionsDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditMitigationActionsTaskResponse, T> g) {
        return obj -> g.apply((DescribeAuditMitigationActionsTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAuditMitigationActionsTaskResponse> {
        /**
         * <p>
         * The current status of the task.
         * </p>
         * 
         * @param taskStatus
         *        The current status of the task.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The current status of the task.
         * </p>
         * 
         * @param taskStatus
         *        The current status of the task.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus);

        /**
         * <p>
         * The date and time when the task was started.
         * </p>
         * 
         * @param startTime
         *        The date and time when the task was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the task was completed or canceled.
         * </p>
         * 
         * @param endTime
         *        The date and time when the task was completed or canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit
         * mitigation actions task.
         * </p>
         * 
         * @param taskStatistics
         *        Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit
         *        mitigation actions task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatistics(Map<String, TaskStatisticsForAuditCheck> taskStatistics);

        /**
         * <p>
         * Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit
         * task, or a set of findings.
         * </p>
         * 
         * @param target
         *        Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by
         *        audit task, or a set of findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(AuditMitigationActionsTaskTarget target);

        /**
         * <p>
         * Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit
         * task, or a set of findings.
         * </p>
         * This is a convenience that creates an instance of the {@link AuditMitigationActionsTaskTarget.Builder}
         * avoiding the need to create one manually via {@link AuditMitigationActionsTaskTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuditMitigationActionsTaskTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(AuditMitigationActionsTaskTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link AuditMitigationActionsTaskTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(AuditMitigationActionsTaskTarget)
         */
        default Builder target(Consumer<AuditMitigationActionsTaskTarget.Builder> target) {
            return target(AuditMitigationActionsTaskTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Specifies the mitigation actions that should be applied to specific audit checks.
         * </p>
         * 
         * @param auditCheckToActionsMapping
         *        Specifies the mitigation actions that should be applied to specific audit checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping);

        /**
         * <p>
         * Specifies the mitigation actions and their parameters that are applied as part of this task.
         * </p>
         * 
         * @param actionsDefinition
         *        Specifies the mitigation actions and their parameters that are applied as part of this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsDefinition(Collection<MitigationAction> actionsDefinition);

        /**
         * <p>
         * Specifies the mitigation actions and their parameters that are applied as part of this task.
         * </p>
         * 
         * @param actionsDefinition
         *        Specifies the mitigation actions and their parameters that are applied as part of this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsDefinition(MitigationAction... actionsDefinition);

        /**
         * <p>
         * Specifies the mitigation actions and their parameters that are applied as part of this task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MitigationAction>.Builder} avoiding the
         * need to create one manually via {@link List<MitigationAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MitigationAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #actionsDefinition(List<MitigationAction>)}.
         * 
         * @param actionsDefinition
         *        a consumer that will call methods on {@link List<MitigationAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsDefinition(List<MitigationAction>)
         */
        Builder actionsDefinition(Consumer<MitigationAction.Builder>... actionsDefinition);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String taskStatus;

        private Instant startTime;

        private Instant endTime;

        private Map<String, TaskStatisticsForAuditCheck> taskStatistics = DefaultSdkAutoConstructMap.getInstance();

        private AuditMitigationActionsTaskTarget target;

        private Map<String, List<String>> auditCheckToActionsMapping = DefaultSdkAutoConstructMap.getInstance();

        private List<MitigationAction> actionsDefinition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditMitigationActionsTaskResponse model) {
            super(model);
            taskStatus(model.taskStatus);
            startTime(model.startTime);
            endTime(model.endTime);
            taskStatistics(model.taskStatistics);
            target(model.target);
            auditCheckToActionsMapping(model.auditCheckToActionsMapping);
            actionsDefinition(model.actionsDefinition);
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Map<String, TaskStatisticsForAuditCheck.Builder> getTaskStatistics() {
            if (taskStatistics instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskStatistics != null ? CollectionUtils.mapValues(taskStatistics, TaskStatisticsForAuditCheck::toBuilder)
                    : null;
        }

        @Override
        public final Builder taskStatistics(Map<String, TaskStatisticsForAuditCheck> taskStatistics) {
            this.taskStatistics = AuditMitigationActionsTaskStatisticsCopier.copy(taskStatistics);
            return this;
        }

        public final void setTaskStatistics(Map<String, TaskStatisticsForAuditCheck.BuilderImpl> taskStatistics) {
            this.taskStatistics = AuditMitigationActionsTaskStatisticsCopier.copyFromBuilder(taskStatistics);
        }

        public final AuditMitigationActionsTaskTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(AuditMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(AuditMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToActionsMapping() {
            if (auditCheckToActionsMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return auditCheckToActionsMapping;
        }

        @Override
        public final Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
            return this;
        }

        public final void setAuditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
        }

        public final Collection<MitigationAction.Builder> getActionsDefinition() {
            if (actionsDefinition instanceof SdkAutoConstructList) {
                return null;
            }
            return actionsDefinition != null ? actionsDefinition.stream().map(MitigationAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionsDefinition(Collection<MitigationAction> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copy(actionsDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(MitigationAction... actionsDefinition) {
            actionsDefinition(Arrays.asList(actionsDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(Consumer<MitigationAction.Builder>... actionsDefinition) {
            actionsDefinition(Stream.of(actionsDefinition).map(c -> MitigationAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActionsDefinition(Collection<MitigationAction.BuilderImpl> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copyFromBuilder(actionsDefinition);
        }

        @Override
        public DescribeAuditMitigationActionsTaskResponse build() {
            return new DescribeAuditMitigationActionsTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
