/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CustomMetricType {
    STRING_LIST("string-list"),
    IP_ADDRESS_LIST("ip-address-list"),
    NUMBER_LIST("number-list"),
    NUMBER("number"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CustomMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CustomMetricType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomMetricType> knownValues() {
        return Stream.of(CustomMetricType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

