/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;

public class ListThingsInBillingGroupIterable
implements SdkIterable<ListThingsInBillingGroupResponse> {
    private final IotClient client;
    private final ListThingsInBillingGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingsInBillingGroupIterable(IotClient client, ListThingsInBillingGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingsInBillingGroupResponseFetcher();
    }

    public Iterator<ListThingsInBillingGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> things() {
        Function<ListThingsInBillingGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingsInBillingGroupResponseFetcher
    implements SyncPageFetcher<ListThingsInBillingGroupResponse> {
        private ListThingsInBillingGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListThingsInBillingGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingsInBillingGroupResponse nextPage(ListThingsInBillingGroupResponse previousPage) {
            if (previousPage == null) {
                return ListThingsInBillingGroupIterable.this.client.listThingsInBillingGroup(ListThingsInBillingGroupIterable.this.firstRequest);
            }
            return ListThingsInBillingGroupIterable.this.client.listThingsInBillingGroup((ListThingsInBillingGroupRequest)((Object)ListThingsInBillingGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

