/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AlertTargetsCopier {
    static Map<String, AlertTarget> copy(Map<String, ? extends AlertTarget> alertTargetsParam) {
        Map<String, AlertTarget> map;
        if (alertTargetsParam == null || alertTargetsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AlertTarget> modifiableMap = new LinkedHashMap<>();
            alertTargetsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AlertTarget> copyFromBuilder(Map<String, ? extends AlertTarget.Builder> alertTargetsParam) {
        Map<String, AlertTarget> map;
        if (alertTargetsParam == null || alertTargetsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AlertTarget> modifiableMap = new LinkedHashMap<>();
            alertTargetsParam.forEach((key, value) -> {
                AlertTarget member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AlertTarget.Builder> copyToBuilder(Map<String, ? extends AlertTarget> alertTargetsParam) {
        Map<String, AlertTarget.Builder> map;
        if (alertTargetsParam == null || alertTargetsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AlertTarget.Builder> modifiableMap = new LinkedHashMap<>();
            alertTargetsParam.forEach((key, value) -> {
                AlertTarget.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AlertTarget> copyEnumToString(Map<AlertTargetType, ? extends AlertTarget> alertTargetsParam) {
        Map<String, AlertTarget> map;
        if (alertTargetsParam == null || alertTargetsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AlertTarget> modifiableMap = new LinkedHashMap<>();
            alertTargetsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<AlertTargetType, AlertTarget> copyStringToEnum(Map<String, ? extends AlertTarget> alertTargetsParam) {
        Map<AlertTargetType, AlertTarget> map;
        if (alertTargetsParam == null || alertTargetsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<AlertTargetType, AlertTarget> modifiableMap = new LinkedHashMap<>();
            alertTargetsParam.forEach((key, value) -> {
                AlertTargetType result = AlertTargetType.fromValue(key);
                if (result != AlertTargetType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
