/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListViolationEventsRequest extends IotRequest implements
        ToCopyableBuilder<ListViolationEventsRequest.Builder, ListViolationEventsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListViolationEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListViolationEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ListViolationEventsRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(ListViolationEventsRequest::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> BEHAVIOR_CRITERIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behaviorCriteriaType").getter(getter(ListViolationEventsRequest::behaviorCriteriaTypeAsString))
            .setter(setter(Builder::behaviorCriteriaType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("behaviorCriteriaType").build())
            .build();

    private static final SdkField<Boolean> LIST_SUPPRESSED_ALERTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("listSuppressedAlerts").getter(getter(ListViolationEventsRequest::listSuppressedAlerts))
            .setter(setter(Builder::listSuppressedAlerts))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("listSuppressedAlerts").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListViolationEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListViolationEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_CRITERIA_TYPE_FIELD,
            LIST_SUPPRESSED_ALERTS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final Instant startTime;

    private final Instant endTime;

    private final String thingName;

    private final String securityProfileName;

    private final String behaviorCriteriaType;

    private final Boolean listSuppressedAlerts;

    private final String nextToken;

    private final Integer maxResults;

    private ListViolationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behaviorCriteriaType = builder.behaviorCriteriaType;
        this.listSuppressedAlerts = builder.listSuppressedAlerts;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The start time for the alerts to be listed.
     * </p>
     * 
     * @return The start time for the alerts to be listed.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the alerts to be listed.
     * </p>
     * 
     * @return The end time for the alerts to be listed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A filter to limit results to those alerts caused by the specified thing.
     * </p>
     * 
     * @return A filter to limit results to those alerts caused by the specified thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * A filter to limit results to those alerts generated by the specified security profile.
     * </p>
     * 
     * @return A filter to limit results to those alerts generated by the specified security profile.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorCriteriaType} will return {@link BehaviorCriteriaType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorCriteriaTypeAsString}.
     * </p>
     * 
     * @return The criteria for a behavior.
     * @see BehaviorCriteriaType
     */
    public final BehaviorCriteriaType behaviorCriteriaType() {
        return BehaviorCriteriaType.fromValue(behaviorCriteriaType);
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorCriteriaType} will return {@link BehaviorCriteriaType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorCriteriaTypeAsString}.
     * </p>
     * 
     * @return The criteria for a behavior.
     * @see BehaviorCriteriaType
     */
    public final String behaviorCriteriaTypeAsString() {
        return behaviorCriteriaType;
    }

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     * 
     * @return A list of all suppressed alerts.
     */
    public final Boolean listSuppressedAlerts() {
        return listSuppressedAlerts;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorCriteriaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(listSuppressedAlerts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViolationEventsRequest)) {
            return false;
        }
        ListViolationEventsRequest other = (ListViolationEventsRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(thingName(), other.thingName())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behaviorCriteriaTypeAsString(), other.behaviorCriteriaTypeAsString())
                && Objects.equals(listSuppressedAlerts(), other.listSuppressedAlerts())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListViolationEventsRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("ThingName", thingName()).add("SecurityProfileName", securityProfileName())
                .add("BehaviorCriteriaType", behaviorCriteriaTypeAsString()).add("ListSuppressedAlerts", listSuppressedAlerts())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behaviorCriteriaType":
            return Optional.ofNullable(clazz.cast(behaviorCriteriaTypeAsString()));
        case "listSuppressedAlerts":
            return Optional.ofNullable(clazz.cast(listSuppressedAlerts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListViolationEventsRequest, T> g) {
        return obj -> g.apply((ListViolationEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListViolationEventsRequest> {
        /**
         * <p>
         * The start time for the alerts to be listed.
         * </p>
         * 
         * @param startTime
         *        The start time for the alerts to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the alerts to be listed.
         * </p>
         * 
         * @param endTime
         *        The end time for the alerts to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A filter to limit results to those alerts caused by the specified thing.
         * </p>
         * 
         * @param thingName
         *        A filter to limit results to those alerts caused by the specified thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A filter to limit results to those alerts generated by the specified security profile.
         * </p>
         * 
         * @param securityProfileName
         *        A filter to limit results to those alerts generated by the specified security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The criteria for a behavior.
         * </p>
         * 
         * @param behaviorCriteriaType
         *        The criteria for a behavior.
         * @see BehaviorCriteriaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorCriteriaType
         */
        Builder behaviorCriteriaType(String behaviorCriteriaType);

        /**
         * <p>
         * The criteria for a behavior.
         * </p>
         * 
         * @param behaviorCriteriaType
         *        The criteria for a behavior.
         * @see BehaviorCriteriaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorCriteriaType
         */
        Builder behaviorCriteriaType(BehaviorCriteriaType behaviorCriteriaType);

        /**
         * <p>
         * A list of all suppressed alerts.
         * </p>
         * 
         * @param listSuppressedAlerts
         *        A list of all suppressed alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSuppressedAlerts(Boolean listSuppressedAlerts);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String thingName;

        private String securityProfileName;

        private String behaviorCriteriaType;

        private Boolean listSuppressedAlerts;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListViolationEventsRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            thingName(model.thingName);
            securityProfileName(model.securityProfileName);
            behaviorCriteriaType(model.behaviorCriteriaType);
            listSuppressedAlerts(model.listSuppressedAlerts);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getBehaviorCriteriaType() {
            return behaviorCriteriaType;
        }

        @Override
        public final Builder behaviorCriteriaType(String behaviorCriteriaType) {
            this.behaviorCriteriaType = behaviorCriteriaType;
            return this;
        }

        @Override
        public final Builder behaviorCriteriaType(BehaviorCriteriaType behaviorCriteriaType) {
            this.behaviorCriteriaType(behaviorCriteriaType == null ? null : behaviorCriteriaType.toString());
            return this;
        }

        public final void setBehaviorCriteriaType(String behaviorCriteriaType) {
            this.behaviorCriteriaType = behaviorCriteriaType;
        }

        public final Boolean getListSuppressedAlerts() {
            return listSuppressedAlerts;
        }

        @Override
        public final Builder listSuppressedAlerts(Boolean listSuppressedAlerts) {
            this.listSuppressedAlerts = listSuppressedAlerts;
            return this;
        }

        public final void setListSuppressedAlerts(Boolean listSuppressedAlerts) {
            this.listSuppressedAlerts = listSuppressedAlerts;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListViolationEventsRequest build() {
            return new ListViolationEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
